/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.level.chunk;

import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.level.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.level.blocksource.BlockSource;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProviderNoiseImitable;
import mod.bluestaggo.modernerbeta.api.level.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.api.level.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.blocksource.BlockSourceRules;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaGenerationStep;
import mod.bluestaggo.modernerbeta.level.spawn.SpawnLocatorIndev;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.FiniteLevelProperties;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.phys.Vec3;
import org.slf4j.event.Level;

public abstract class ChunkProviderFinite
extends ChunkProvider
implements ChunkProviderNoiseImitable {
    private static String levelPhase;
    protected final int worldMinY;
    protected final int worldHeight;
    protected final int worldTopY;
    protected final int bedrockFloor;
    protected final int bedrockCeiling;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    protected final FiniteLevelProperties levelProperties;
    protected final int levelWidth;
    protected final int levelLength;
    protected final int levelHeight;
    protected final float caveRadius;
    protected final int[] heightmap;
    @Deprecated
    private final Block[][][] blockArr;
    private boolean pregenerated;

    public ChunkProviderFinite(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)chunkGenerator.generatorSettings().value();
        NoiseSettings shapeConfig = generatorSettings.noiseSettings();
        this.levelProperties = this.getChunkSettings().getOrDefault(SettingsComponentTypes.FINITE_LEVEL_PROPERTIES);
        this.worldMinY = shapeConfig.minY();
        this.worldHeight = shapeConfig.height();
        this.worldTopY = this.worldHeight + this.worldMinY;
        this.bedrockFloor = 0;
        this.bedrockCeiling = Integer.MIN_VALUE;
        this.defaultBlock = generatorSettings.defaultBlock();
        this.defaultFluid = generatorSettings.defaultFluid();
        this.levelWidth = this.levelProperties.width();
        this.levelLength = this.levelProperties.length();
        this.levelHeight = Mth.clamp((int)this.levelProperties.height(), (int)0, (int)this.worldTopY);
        this.caveRadius = this.getChunkSettings().getOrDefault(SettingsComponentTypes.FINITE_CAVE_GENERATION).radius();
        this.heightmap = new int[this.levelWidth * this.levelLength];
        this.blockArr = new Block[this.levelWidth][this.levelHeight][this.levelLength];
        this.fillBlockArr(Blocks.AIR);
        this.pregenerated = false;
    }

    @Override
    public SpawnLocator getSpawnLocator() {
        return new SpawnLocatorIndev(this);
    }

    @Override
    public CompletableFuture<ChunkAccess> provideChunk(Blender blender, StructureManager structureAccessor, ChunkAccess chunk, RandomState noiseConfig) {
        ChunkPos pos = chunk.getPos();
        if (this.inWorldBounds(pos.getMinBlockX(), pos.getMinBlockZ())) {
            this.pregenerateTerrainOrWait();
            this.generateTerrain(chunk, structureAccessor);
        } else {
            this.generateBorder(chunk);
        }
        return CompletableFuture.supplyAsync(() -> chunk, (Executor)Util.backgroundExecutor());
    }

    @Override
    public void provideSurface(WorldGenRegion region, StructureManager structureAccessor, ChunkAccess chunk, ModernBetaBiomeSource biomeSource, RandomState noiseConfig) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int startX = chunk.getPos().getMinBlockX();
        int startZ = chunk.getPos().getMinBlockZ();
        int worldTopY = this.worldHeight + this.worldMinY;
        int seaLevel = this.chunkGenerator.getSeaLevel();
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                ClimateSampler climateSampler;
                int x = startX + localX;
                int z = startZ + localZ;
                Holder<Biome> biome = biomeSource.getBiomeForSurfaceGen(region, (BlockPos)pos.set(x, 0, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                BiomeProvider biomeProvider = biomeSource.getBiomeProvider();
                boolean isCold = biomeProvider instanceof ClimateSampler && (climateSampler = (ClimateSampler)((Object)biomeProvider)).useBiomeFeature() ? climateSampler.sample(x, z).temp() < 0.5 : ((Biome)biome.value()).coldEnoughToSnow((BlockPos)pos, seaLevel);
                for (int y = worldTopY - 1; y >= this.worldMinY; --y) {
                    pos.set(x, y, z);
                    BlockState blockState = this.postProcessSurfaceState(chunk.getBlockState((BlockPos)pos), surfaceConfig, (BlockPos)pos, isCold);
                    VersionCompat.setBlockState(chunk, (BlockPos)pos, blockState);
                    if (!blockState.hasProperty((Property)BlockStateProperties.SNOWY) || !((Boolean)blockState.getValue((Property)BlockStateProperties.SNOWY)).booleanValue()) continue;
                    VersionCompat.setBlockState(chunk, pos.above(), BlockStates.SNOW);
                }
            }
        }
    }

    @Override
    public int getHeight(LevelHeightAccessor level, int x, int z, Heightmap.Types type) {
        int seaLevel = this.getSeaLevel();
        if ((x += this.levelWidth / 2) < 0 || x >= this.levelWidth || (z += this.levelLength / 2) < 0 || z >= this.levelLength) {
            return seaLevel;
        }
        this.pregenerateTerrainOrWait();
        int height = this.getLevelHighestBlock(x, z, type);
        return height;
    }

    @Override
    public boolean skipChunk(int chunkX, int chunkZ, ModernBetaGenerationStep step) {
        boolean outOfBounds;
        boolean bl = outOfBounds = !this.inWorldBounds(chunkX << 4, chunkZ << 4);
        if (step == ModernBetaGenerationStep.FEATURES) {
            return outOfBounds;
        }
        if (step == ModernBetaGenerationStep.STRUCTURE_STARTS) {
            return outOfBounds;
        }
        if (step == ModernBetaGenerationStep.CARVERS) {
            return outOfBounds || this.skipCarvers;
        }
        if (step == ModernBetaGenerationStep.SURFACE) {
            return false;
        }
        if (step == ModernBetaGenerationStep.ENTITY_SPAWN) {
            return outOfBounds;
        }
        return false;
    }

    @Override
    public Aquifer getAquiferSampler(ChunkAccess chunk, RandomState noiseConfig) {
        Aquifer.FluidPicker fluidLevelSampler = (x, y, z) -> new Aquifer.FluidStatus(this.getSeaLevel(), this.getLevelFluidBlock().defaultBlockState());
        return Aquifer.createDisabled((Aquifer.FluidPicker)fluidLevelSampler);
    }

    public int getLevelWidth() {
        return this.levelWidth;
    }

    public int getLevelLength() {
        return this.levelLength;
    }

    public int getLevelHeight() {
        return this.levelHeight;
    }

    public float getCaveRadius() {
        return this.caveRadius;
    }

    public Block getLevelBlock(int x, int y, int z) {
        x = Mth.clamp((int)x, (int)0, (int)(this.levelWidth - 1));
        y = Mth.clamp((int)y, (int)0, (int)(this.levelHeight - 1));
        z = Mth.clamp((int)z, (int)0, (int)(this.levelLength - 1));
        return this.blockArr[x][y][z];
    }

    public void setLevelBlock(int x, int y, int z, Block block) {
        x = Mth.clamp((int)x, (int)0, (int)(this.levelWidth - 1));
        y = Mth.clamp((int)y, (int)0, (int)(this.levelHeight - 1));
        z = Mth.clamp((int)z, (int)0, (int)(this.levelLength - 1));
        this.blockArr[x][y][z] = block;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public int getLevelHighestBlock(int x, int z, Heightmap.Types type) {
        x = Mth.clamp((int)x, (int)0, (int)(this.levelWidth - 1));
        z = Mth.clamp((int)z, (int)0, (int)(this.levelLength - 1));
        Predicate<Block> checkBlock = switch (type) {
            case Heightmap.Types.OCEAN_FLOOR_WG -> block -> block == Blocks.AIR || block == this.getLevelFluidBlock();
            case Heightmap.Types.WORLD_SURFACE_WG -> block -> block == Blocks.AIR;
            default -> block -> block == Blocks.AIR;
        };
        int y = this.levelHeight;
        while (checkBlock.test(this.getLevelBlock(x, y - 1, z))) {
            if (y <= 0) return y;
            --y;
        }
        return y;
    }

    public Block getLevelFluidBlock() {
        return this.defaultFluid.getBlock();
    }

    protected abstract void pregenerateTerrain();

    protected abstract void generateBorder(ChunkAccess var1);

    protected abstract BlockState postProcessTerrainState(Block var1, BlockSourceRules var2, TerrainState var3, BlockPos var4, int var5);

    protected abstract void generateBedrock(ChunkAccess var1, Block var2, BlockPos var3);

    protected abstract BlockState postProcessSurfaceState(BlockState var1, SurfaceConfig var2, BlockPos var3, boolean var4);

    protected void generateTerrain(ChunkAccess chunk, StructureManager structureAccessor) {
        int chunkX = chunk.getPos().x;
        int chunkZ = chunk.getPos().z;
        int offsetX = (chunkX + this.levelWidth / 16 / 2) * 16;
        int offsetZ = (chunkZ + this.levelLength / 16 / 2) * 16;
        Heightmap heightmapOcean = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmapSurface = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        Beardifier structureWeightSampler = Beardifier.forStructuresInChunk((StructureManager)structureAccessor, (ChunkPos)chunk.getPos());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        SimpleNoisePos noisePos = new SimpleNoisePos();
        ChunkProviderNoiseImitable.BlockHolder blockHolder = new ChunkProviderNoiseImitable.BlockHolder();
        BlockSource baseBlockSource = this.getBaseBlockSource(structureWeightSampler, noisePos, blockHolder, this.defaultBlock.getBlock(), this.getLevelFluidBlock());
        BlockSourceRules blockSources = new BlockSourceRules.Builder().add(baseBlockSource).add(this.getActualBlockSource(blockHolder)).build(this.defaultBlock);
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = localX + (chunkX << 4);
                int z = localZ + (chunkZ << 4);
                int topY = this.getHeight(null, x, z, Heightmap.Types.OCEAN_FLOOR_WG);
                TerrainState terrainState = new TerrainState();
                for (int y = this.levelHeight - 1; y >= 0; --y) {
                    pos.set(x, y, z);
                    Block block = this.getLevelBlock(offsetX + localX, y, offsetZ + localZ);
                    blockHolder.setBlock(block);
                    BlockState blockState = this.postProcessTerrainState(block, blockSources, terrainState, (BlockPos)pos, topY);
                    VersionCompat.setBlockState(chunk, (BlockPos)pos.set(localX, y, localZ), blockState);
                    this.generateBedrock(chunk, block, (BlockPos)pos);
                    heightmapOcean.update(localX, y, localZ, block.defaultBlockState());
                    heightmapSurface.update(localX, y, localZ, block.defaultBlockState());
                }
            }
        }
    }

    protected boolean inWorldBounds(int x, int z) {
        int halfWidth = this.levelWidth / 2;
        int halfLength = this.levelLength / 2;
        return x >= -halfWidth && x < halfWidth && z >= -halfLength && z < halfLength;
    }

    protected boolean inLevelBounds(int x, int y, int z) {
        return x >= 0 && x < this.levelWidth && y >= 0 && y < this.levelHeight && z >= 0 && z < this.levelLength;
    }

    protected void setPhase(String phase) {
        levelPhase = phase + "..";
        ModernerBeta.log(Level.INFO, levelPhase);
    }

    protected void fillOblateSpheroid(float centerX, float centerY, float centerZ, float radius, Block fillBlock) {
        for (int x = (int)(centerX - radius); x < (int)(centerX + radius); ++x) {
            for (int y = (int)(centerY - radius); y < (int)(centerY + radius); ++y) {
                for (int z = (int)(centerZ - radius); z < (int)(centerZ + radius); ++z) {
                    Block block;
                    float dx = (float)x - centerX;
                    float dy = (float)y - centerY;
                    float dz = (float)z - centerZ;
                    if (!(dx * dx + dy * dy * 2.0f + dz * dz < radius * radius) || !this.inLevelBounds(x, y, z) || (block = this.getLevelBlock(x, y, z)) != this.defaultBlock.getBlock()) continue;
                    this.setLevelBlock(x, y, z, fillBlock);
                }
            }
        }
    }

    protected void flood(int x, int y, int z, Block fillBlock) {
        ArrayDeque<Vec3> positions = new ArrayDeque<Vec3>();
        positions.add(new Vec3((double)x, (double)y, (double)z));
        while (!positions.isEmpty()) {
            Vec3 curPos = (Vec3)positions.poll();
            x = (int)curPos.x;
            y = (int)curPos.y;
            z = (int)curPos.z;
            Block block = this.getLevelBlock(x, y, z);
            if (block != Blocks.AIR) continue;
            this.setLevelBlock(x, y, z, fillBlock);
            if (y - 1 >= 0) {
                this.tryFlood(x, y - 1, z, positions);
            }
            if (x - 1 >= 0) {
                this.tryFlood(x - 1, y, z, positions);
            }
            if (x + 1 < this.levelWidth) {
                this.tryFlood(x + 1, y, z, positions);
            }
            if (z - 1 >= 0) {
                this.tryFlood(x, y, z - 1, positions);
            }
            if (z + 1 >= this.levelLength) continue;
            this.tryFlood(x, y, z + 1, positions);
        }
    }

    private void tryFlood(int x, int y, int z, ArrayDeque<Vec3> positions) {
        Block block = this.getLevelBlock(x, y, z);
        if (block == Blocks.AIR) {
            positions.add(new Vec3((double)x, (double)y, (double)z));
        }
    }

    private synchronized void pregenerateTerrainOrWait() {
        if (!this.pregenerated) {
            this.pregenerateTerrain();
            this.pregenerated = true;
        }
    }

    private void fillBlockArr(Block block) {
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                for (int y = 0; y < this.levelHeight; ++y) {
                    this.setLevelBlock(x, y, z, block);
                }
            }
        }
    }

    public static void resetPhase() {
        levelPhase = "";
    }

    public static String getPhase() {
        return levelPhase;
    }

    protected static class TerrainState {
        private int runDepth = 0;
        private boolean terrainModified = false;

        public int getRunDepth() {
            return this.runDepth;
        }

        public void incrementRunDepth() {
            ++this.runDepth;
        }

        public boolean isTerrainModified() {
            return this.terrainModified;
        }

        public void terrainModified() {
            this.terrainModified = true;
        }
    }
}

