/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.level.chunk;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.level.biome.HeightConfig;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.ForcedBiomeHeight;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.BiomeSource;

public abstract class ChunkProviderForcedHeight
extends ChunkProviderNoise {
    private final int heightSampleRadius;
    private final float[] biomeHeightWeights;
    private final Map<ExtendedBiomeId, HeightConfig> biomeHeightValues;
    private final ForcedBiomeHeight forcedBiomeHeight = this.getChunkSettings().getOrDefault(SettingsComponentTypes.FORCED_BIOME_HEIGHT);

    public ChunkProviderForcedHeight(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        this.biomeHeightValues = Stream.concat(this.forcedBiomeHeight.heightOverrides().entrySet().stream(), ModernBetaRegistries.HEIGHT_CONFIG.listElements().filter(Holder::isBound).flatMap(entry -> {
            TagKey heightConfigTag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)((ResourceKey)entry.unwrapKey().orElseThrow()).location());
            HeightConfig heightConfig = (HeightConfig)entry.value();
            return chunkGenerator.getBiomeSource().possibleBiomes().stream().filter(biome -> biome.is(heightConfigTag)).map(biome -> ExtendedBiomeId.of(((ResourceKey)biome.unwrapKey().orElseThrow()).location(), heightConfig.type())).filter(extId -> !this.forcedBiomeHeight.heightOverrides().containsKey(extId)).map(extId -> Map.entry(extId, heightConfig));
        })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (base, duplicate) -> base));
        int hsr = this.heightSampleRadius = this.getHeightSampleRadius();
        int hsd = 2 * this.heightSampleRadius + 1;
        this.biomeHeightWeights = new float[hsd * hsd];
        for (int x = -hsr; x <= hsr; ++x) {
            for (int z = -hsr; z <= hsr; ++z) {
                this.biomeHeightWeights[x + hsr + (z + hsr) * hsd] = this.calculateBiomeHeightWeight(x, z);
            }
        }
    }

    public ExtendedBiomeId getExtendedBiomeId(int biomeX, int biomeZ) {
        BiomeSource biomeSource = this.chunkGenerator.getBiomeSource();
        if (biomeSource instanceof ModernBetaBiomeSource) {
            ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource;
            return modernBetaBiomeSource.getBiomeForHeightGen(biomeX, 16, biomeZ);
        }
        return ExtendedBiomeId.of(((ResourceKey)this.getBiome(biomeX, 16, biomeZ, null).unwrapKey().orElseThrow()).location());
    }

    public HeightConfig getHeightConfigOfBiome(ExtendedBiomeId extendedBiomeId) {
        return this.biomeHeightValues.getOrDefault(extendedBiomeId, HeightConfig.DEFAULT);
    }

    public HeightConfig getRawHeightConfigAt(int x, int z) {
        return this.getHeightConfigOfBiome(this.getExtendedBiomeId(x, z));
    }

    public HeightConfig getHeightConfigAt(int noiseX, int noiseZ) {
        float scale = 0.0f;
        float depth = 0.0f;
        float totalWeight = 0.0f;
        ExtendedBiomeId biome = this.getExtendedBiomeId(noiseX, noiseZ);
        double minSurfaceHeight = this.getHeightConfigOfBiome(biome).depth();
        int hsr = this.heightSampleRadius;
        int hsd = 2 * this.heightSampleRadius + 1;
        for (int biomeX = -hsr; biomeX <= hsr; ++biomeX) {
            for (int biomeZ = -hsr; biomeZ <= hsr; ++biomeZ) {
                float weight = this.biomeHeightWeights[biomeX + hsr + (biomeZ + hsr) * hsd];
                if (weight <= 0.0f) continue;
                biome = this.getExtendedBiomeId(noiseX + biomeX, noiseZ + biomeZ);
                HeightConfig heightConfig = this.getHeightConfigOfBiome(biome);
                float thisScale = heightConfig.scale();
                float thisDepth = heightConfig.depth();
                if (!this.forcedBiomeHeight.modifyOnlyPositiveDepth() || thisDepth > 0.0f) {
                    thisScale = this.forcedBiomeHeight.scaleOffset() + thisScale * this.forcedBiomeHeight.scaleWeight();
                    thisDepth = this.forcedBiomeHeight.depthOffset() + thisDepth * this.forcedBiomeHeight.depthWeight();
                }
                weight /= Math.max(thisDepth + 2.0f, 0.01f);
                if ((double)heightConfig.depth() > minSurfaceHeight) {
                    weight /= 2.0f;
                }
                scale += thisScale * weight;
                depth += thisDepth * weight;
                totalWeight += weight;
            }
        }
        scale /= totalWeight;
        depth /= totalWeight;
        scale = scale * 0.9f + 0.1f;
        depth = (depth * 4.0f - 1.0f) / 8.0f;
        return new HeightConfig(depth, scale);
    }

    protected int getHeightSampleRadius() {
        return 2;
    }

    protected float calculateBiomeHeightWeight(int x, int z) {
        return 10.0f / Mth.sqrt((float)((float)(x * x + z * z) + 0.2f));
    }
}

