/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.level.chunk;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.api.level.blocksource.BlockSource;
import mod.bluestaggo.modernerbeta.api.level.chunk.AquiferSamplerProvider;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.level.chunk.noise.NoisePostProcessor;
import mod.bluestaggo.modernerbeta.api.level.chunk.noise.NoiseProvider;
import mod.bluestaggo.modernerbeta.api.level.chunk.noise.NoiseProviderBase;
import mod.bluestaggo.modernerbeta.api.level.chunk.noise.NoiseSampler;
import mod.bluestaggo.modernerbeta.level.blocksource.BlockSourceRules;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkNoiseSampler;
import mod.bluestaggo.modernerbeta.level.chunk.provider.island.IslandShape;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.CaveGeneration;
import mod.bluestaggo.modernerbeta.settings.component.IslesProperties;
import mod.bluestaggo.modernerbeta.settings.component.NoiseScale;
import mod.bluestaggo.modernerbeta.settings.component.NoiseSlide;
import mod.bluestaggo.modernerbeta.settings.component.SurfaceProperties;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkCache;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.util.chunk.LevelChunkCache;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import mod.bluestaggo.modernerbeta.util.noise.SimplexNoise;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public abstract class ChunkProviderNoise
extends ChunkProvider {
    protected final int worldMinY;
    protected final int worldHeight;
    protected final int worldTopY;
    protected final int bedrockFloor;
    protected final int bedrockCeiling;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    protected final int noiseResolutionVertical;
    protected final int noiseResolutionHorizontal;
    protected final int noiseSizeX;
    protected final int noiseSizeZ;
    protected final int noiseSizeY;
    protected final int noiseMinY;
    protected final int noiseTopY;
    private final ChunkCache<NoiseProviderBase> chunkCacheNoise;
    private final LevelChunkCache<ChunkHeightmap> chunkCacheHeightmap;
    protected final List<NoisePostProcessor> noisePostProcessors = new ArrayList<NoisePostProcessor>();
    private final SimplexNoise islandNoise;
    private final IslesProperties islesProperties;
    protected final NoiseScale noiseScale;
    private final NoiseSlide noiseSlide;
    private final AtomicReference<RandomState> noiseConfig = new AtomicReference();

    public ChunkProviderNoise(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)chunkGenerator.generatorSettings().value();
        NoiseSettings noiseSettings = this.getNoiseSettings();
        this.islesProperties = this.getChunkSettings().getOrDefault(SettingsComponentTypes.ISLES_PROPERTIES);
        this.noiseScale = this.getChunkSettings().getOrDefault(SettingsComponentTypes.NOISE_SCALE);
        this.noiseSlide = this.getChunkSettings().getOrElse(SettingsComponentTypes.NOISE_SLIDE, NoiseSlide.DISABLED);
        this.worldMinY = noiseSettings.minY();
        this.worldHeight = noiseSettings.height();
        this.worldTopY = this.worldHeight + this.worldMinY;
        this.bedrockFloor = this.worldMinY;
        this.bedrockCeiling = this.worldTopY;
        this.defaultBlock = generatorSettings.defaultBlock();
        this.defaultFluid = generatorSettings.defaultFluid();
        this.noiseResolutionVertical = noiseSettings.noiseSizeVertical() * 4;
        this.noiseResolutionHorizontal = noiseSettings.noiseSizeHorizontal() * 4;
        this.noiseSizeX = 16 / this.noiseResolutionHorizontal;
        this.noiseSizeZ = 16 / this.noiseResolutionHorizontal;
        this.noiseSizeY = Mth.floorDiv((int)this.worldHeight, (int)this.noiseResolutionVertical);
        this.noiseMinY = Mth.floorDiv((int)this.worldMinY, (int)this.noiseResolutionVertical);
        this.noiseTopY = Mth.floorDiv((int)(this.worldMinY + this.worldHeight), (int)this.noiseResolutionVertical);
        this.chunkCacheNoise = new ChunkCache<NoiseProviderBase>("base_noise", (chunkX, chunkZ) -> {
            NoiseProviderBase noiseProviderBase = new NoiseProviderBase(this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ, this::sampleNoiseColumn);
            noiseProviderBase.sampleInitialNoise(chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ);
            return noiseProviderBase;
        });
        this.chunkCacheHeightmap = new LevelChunkCache("heightmap", this::sampleHeightmap);
        this.islandNoise = new SimplexNoise(this.createRandom(this.seed));
        CaveGeneration caveSettings = this.getChunkSettings().getOrDefault(SettingsComponentTypes.CAVE_GENERATION);
        if (caveSettings.useNoiseCaves()) {
            this.noisePostProcessors.add(NoisePostProcessor.NOISE_CAVES);
        }
    }

    @Override
    public CompletableFuture<ChunkAccess> provideChunk(Blender blender, StructureManager structureAccessor, ChunkAccess chunk, RandomState noiseConfig) {
        this.setNoiseConfig(noiseConfig);
        NoiseSettings noiseSettings = this.getNoiseSettings().clampToHeightAccessor(chunk.getHeightAccessorForGeneration());
        int minY = noiseSettings.minY();
        int minimumCellY = Mth.floorDiv((int)minY, (int)noiseSettings.getCellHeight());
        int cellHeight = Mth.floorDiv((int)noiseSettings.height(), (int)noiseSettings.getCellHeight());
        return cellHeight <= 0 ? CompletableFuture.completedFuture(chunk) : CompletableFuture.supplyAsync(() -> {
            int sectionTopY = chunk.getSectionIndex(cellHeight * noiseSettings.getCellHeight() - 1 + minY);
            int sectionMinY = chunk.getSectionIndex(minY);
            HashSet sections = Sets.newHashSet();
            for (int sectionNdx = sectionTopY; sectionNdx >= sectionMinY; --sectionNdx) {
                LevelChunkSection section = chunk.getSection(sectionNdx);
                section.acquire();
                sections.add(section);
            }
            try {
                this.generateTerrain(chunk, structureAccessor, noiseConfig, minimumCellY, cellHeight);
            }
            finally {
                for (LevelChunkSection section : sections) {
                    section.release();
                }
            }
            return chunk;
        }, (Executor)Util.backgroundExecutor());
    }

    @Override
    public int getHeight(LevelHeightAccessor level, int x, int z, Heightmap.Types type) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.chunkCacheHeightmap.get(level, chunkX, chunkZ).getHeight(x, z, type);
    }

    public int getHeight(LevelHeightAccessor level, int x, int z, ChunkHeightmap.Type type) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.chunkCacheHeightmap.get(level, chunkX, chunkZ).getHeight(x, z, type);
    }

    @Override
    public Aquifer getAquiferSampler(ChunkAccess chunk, RandomState noiseConfig) {
        SurfaceProperties surfaceProperties = this.getChunkSettings().getOrDefault(SettingsComponentTypes.SURFACE_PROPERTIES);
        PositionalRandomFactory randomDeriver = this.randomSource.newInstance(this.seed).forkPositional();
        NoiseChunk noiseSampler = ModernBetaChunkNoiseSampler.create(chunk, noiseConfig, (NoiseGeneratorSettings)this.generatorSettings.value(), this.getFluidLevelSampler(), this);
        AquiferSamplerProvider aquiferSamplerProvider = new AquiferSamplerProvider(((NoiseGeneratorSettings)this.generatorSettings.value()).noiseRouter(), randomDeriver, noiseSampler, this.defaultFluid, this.getSeaLevel(), this.worldMinY + 10, this.worldMinY, this.worldHeight, this.noiseResolutionVertical, ((NoiseGeneratorSettings)this.generatorSettings.value()).aquifersEnabled() && surfaceProperties.generateLiquids());
        return aquiferSamplerProvider.provideAquiferSampler(chunk);
    }

    public void setNoiseConfig(RandomState noiseConfig) {
        this.noiseConfig.set(noiseConfig);
    }

    protected abstract void sampleNoiseColumn(double[] var1, double[] var2, int var3, int var4, int var5, int var6);

    protected boolean hasNoisePostProcessor() {
        return !this.noisePostProcessors.isEmpty();
    }

    protected double sampleNoisePostProcessor(double noise, int noiseX, int noiseY, int noiseZ) {
        RandomState noiseConfig = this.noiseConfig.get();
        if (!this.hasNoisePostProcessor() || noiseConfig == null) {
            return noise;
        }
        for (NoisePostProcessor noisePostProcessor : this.noisePostProcessors) {
            noise = noisePostProcessor.sample(noise, noiseX, noiseY, noiseZ, noiseConfig, (NoiseGeneratorSettings)this.generatorSettings.value(), this.chunkSettings);
        }
        return noise;
    }

    protected double getIslandOffset(int noiseX, int noiseZ) {
        if (!this.islesProperties.useIslands()) {
            return 0.0;
        }
        Function<Integer, Integer> toNoiseCoord = chunkCoord -> chunkCoord * this.noiseSizeX;
        IslandShape islandShape = this.islesProperties.centerIslandShape();
        double distance = islandShape.getDistance(noiseX, noiseZ);
        double oceanSlideTarget = this.islesProperties.oceanSlideTarget();
        int centerIslandRadius = toNoiseCoord.apply(this.islesProperties.centerIslandRadius());
        int centerIslandFalloffDistance = toNoiseCoord.apply(this.islesProperties.centerIslandFalloffDistance());
        int centerOceanRadius = toNoiseCoord.apply(this.islesProperties.centerOceanRadius());
        int centerOceanFalloffDistance = toNoiseCoord.apply(this.islesProperties.centerOceanFalloffDistance());
        double outerIslandNoiseScale = this.islesProperties.outerIslandNoiseScale();
        double outerIslandNoiseOffset = this.islesProperties.outerIslandNoiseOffset();
        double islandDelta = (distance - (double)centerIslandRadius) / (double)centerIslandFalloffDistance;
        double islandOffset = VersionCompat.clampedLerp(0.0, oceanSlideTarget, islandDelta);
        if (this.islesProperties.useOuterIslands() && distance > (double)centerOceanRadius) {
            double islandAddition = (double)((float)this.islandNoise.sample((double)noiseX / outerIslandNoiseScale, (double)noiseZ / outerIslandNoiseScale, 1.0, 1.0)) + outerIslandNoiseOffset;
            islandAddition /= (double)0.8f;
            islandAddition = Mth.clamp((double)islandAddition, (double)0.0, (double)1.0);
            double oceanDelta = (distance - (double)centerOceanRadius) / (double)centerOceanFalloffDistance;
            islandAddition = VersionCompat.clampedLerp(0.0, islandAddition, oceanDelta);
            islandOffset += islandAddition * -oceanSlideTarget;
            islandOffset = Mth.clamp((double)islandOffset, (double)oceanSlideTarget, (double)0.0);
        }
        return islandOffset;
    }

    protected double applySlides(double density, int noiseY) {
        double delta;
        if (this.noiseSlide.topSize() > 0) {
            delta = ((double)(this.noiseSizeY - noiseY) - (double)this.noiseSlide.topOffset()) / (double)this.noiseSlide.topSize();
            density = VersionCompat.clampedLerp(this.noiseSlide.topTarget(), density, delta);
        }
        if (this.noiseSlide.bottomSize() > 0) {
            delta = ((double)noiseY - (double)this.noiseSlide.bottomOffset()) / (double)this.noiseSlide.bottomSize();
            density = VersionCompat.clampedLerp(this.noiseSlide.bottomTarget(), density, delta);
        }
        return density;
    }

    protected void scheduleFluidTick(ChunkAccess chunk, Aquifer aquiferSampler, BlockPos pos, BlockState blockState) {
        if (aquiferSampler.shouldScheduleFluidUpdate() && !blockState.getFluidState().isEmpty()) {
            chunk.markPosForPostprocessing(pos);
        }
    }

    protected ChunkHeightmap getChunkHeightmap(LevelHeightAccessor level, int chunkX, int chunkZ) {
        return this.chunkCacheHeightmap.get(level, chunkX, chunkZ);
    }

    protected boolean isBlockSuitableForSurface(BlockState blockState) {
        return blockState.canOcclude() && !blockState.is(this.defaultBlock.getBlock());
    }

    private void generateTerrain(ChunkAccess chunk, StructureManager structureAccessor, RandomState noiseConfig, int minimumCellY, int cellHeight) {
        ChunkPos chunkPos = chunk.getPos();
        int chunkX = chunkPos.x;
        int chunkZ = chunkPos.z;
        int startX = chunkPos.getMinBlockX();
        int startZ = chunkPos.getMinBlockZ();
        Heightmap heightmapOcean = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmapSurface = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        Beardifier structureWeightSampler = Beardifier.forStructuresInChunk((StructureManager)structureAccessor, (ChunkPos)chunkPos);
        Aquifer aquiferSampler = this.getAquiferSampler(chunk, noiseConfig);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        NoiseProvider noiseProvider = this.chunkCacheNoise.get(chunkX, chunkZ);
        NoiseSampler noiseSampler = noiseProvider.getSampler();
        BlockSource baseBlockSource = this.getBaseBlockSource(noiseSampler, structureWeightSampler, aquiferSampler);
        BlockSourceRules.Builder builder = new BlockSourceRules.Builder().add(baseBlockSource);
        this.blockSources.forEach(builder::add);
        BlockSourceRules blockSources = builder.build(this.defaultBlock);
        for (int subChunkX = 0; subChunkX < this.noiseSizeX; ++subChunkX) {
            for (int subChunkZ = 0; subChunkZ < this.noiseSizeZ; ++subChunkZ) {
                int sections = chunk.getSectionsCount() - 1;
                LevelChunkSection section = chunk.getSection(sections);
                for (int subChunkY = cellHeight - 1; subChunkY >= 0; --subChunkY) {
                    noiseSampler.sampleNoiseCorners(subChunkX, subChunkY, subChunkZ);
                    for (int subY = this.noiseResolutionVertical - 1; subY >= 0; --subY) {
                        int y = subY + (subChunkY + minimumCellY) * this.noiseResolutionVertical;
                        int localY = y & 0xF;
                        int sectionNdx = chunk.getSectionIndex(y);
                        if (sections != sectionNdx) {
                            sections = sectionNdx;
                            section = chunk.getSection(sectionNdx);
                        }
                        double deltaY = (double)subY / (double)this.noiseResolutionVertical;
                        noiseSampler.sampleNoiseY(deltaY);
                        for (int subX = 0; subX < this.noiseResolutionHorizontal; ++subX) {
                            int localX = subX + subChunkX * this.noiseResolutionHorizontal;
                            int x = startX + localX;
                            double deltaX = (double)subX / (double)this.noiseResolutionHorizontal;
                            noiseSampler.sampleNoiseX(deltaX);
                            for (int subZ = 0; subZ < this.noiseResolutionHorizontal; ++subZ) {
                                int localZ = subZ + subChunkZ * this.noiseResolutionHorizontal;
                                int z = startZ + localZ;
                                double deltaZ = (double)subZ / (double)this.noiseResolutionHorizontal;
                                noiseSampler.sampleNoiseZ(deltaZ);
                                BlockState blockState = blockSources.apply(x, y, z);
                                if (blockState.equals((Object)BlockStates.AIR)) continue;
                                section.setBlockState(localX, localY, localZ, blockState, false);
                                heightmapOcean.update(localX, y, localZ, blockState);
                                heightmapSurface.update(localX, y, localZ, blockState);
                                this.scheduleFluidTick(chunk, aquiferSampler, (BlockPos)mutable.set(x, y, z), blockState);
                            }
                        }
                    }
                }
            }
        }
    }

    private ChunkHeightmap sampleHeightmap(LevelHeightAccessor level, int chunkX, int chunkZ) {
        NoiseSettings noiseSettings = this.getNoiseSettings();
        if (level != null) {
            noiseSettings = noiseSettings.clampToHeightAccessor(level);
        }
        short minHeight = 32;
        short worldMinY = (short)noiseSettings.minY();
        short worldTopY = (short)(noiseSettings.height() + worldMinY);
        int minimumCellY = Mth.floorDiv((int)worldMinY, (int)noiseSettings.getCellHeight());
        int cellHeight = Mth.floorDiv((int)noiseSettings.height(), (int)noiseSettings.getCellHeight());
        int seaLevel = this.getSeaLevel();
        NoiseProviderBase noiseProvider = new NoiseProviderBase(this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ, this::sampleNoiseColumn);
        noiseProvider.sampleInitialNoise(chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ);
        NoiseSampler noiseSampler = noiseProvider.getSamplerForHeightmap();
        short[] heightmapSurface = new short[256];
        short[] heightmapOcean = new short[256];
        short[] heightmapSurfaceFloor = new short[256];
        Arrays.fill(heightmapSurface, minHeight);
        Arrays.fill(heightmapOcean, minHeight);
        Arrays.fill(heightmapSurfaceFloor, worldMinY);
        for (int subChunkX = 0; subChunkX < this.noiseSizeX; ++subChunkX) {
            for (int subChunkZ = 0; subChunkZ < this.noiseSizeZ; ++subChunkZ) {
                for (int subChunkY = 0; subChunkY < cellHeight; ++subChunkY) {
                    noiseSampler.sampleNoiseCorners(subChunkX, subChunkY, subChunkZ);
                    for (int subY = 0; subY < this.noiseResolutionVertical; ++subY) {
                        int y = subY + (subChunkY + minimumCellY) * this.noiseResolutionVertical;
                        double deltaY = (double)subY / (double)this.noiseResolutionVertical;
                        noiseSampler.sampleNoiseY(deltaY);
                        for (int subX = 0; subX < this.noiseResolutionHorizontal; ++subX) {
                            int x = subX + subChunkX * this.noiseResolutionHorizontal;
                            double deltaX = (double)subX / (double)this.noiseResolutionHorizontal;
                            noiseSampler.sampleNoiseX(deltaX);
                            for (int subZ = 0; subZ < this.noiseResolutionHorizontal; ++subZ) {
                                int z = subZ + subChunkZ * this.noiseResolutionHorizontal;
                                double deltaZ = (double)subZ / (double)this.noiseResolutionHorizontal;
                                noiseSampler.sampleNoiseZ(deltaZ);
                                double density = noiseSampler.sample();
                                boolean isSolid = density > 0.0;
                                short height = (short)(y + 1);
                                int ndx = z + x * 16;
                                if (y < seaLevel || isSolid) {
                                    heightmapOcean[ndx] = height;
                                }
                                if (isSolid) {
                                    heightmapSurface[ndx] = height;
                                }
                                if (isSolid && heightmapSurfaceFloor[ndx] == worldMinY) {
                                    heightmapSurfaceFloor[ndx] = worldTopY;
                                }
                                if (isSolid || heightmapSurfaceFloor[ndx] != worldTopY) continue;
                                heightmapSurfaceFloor[ndx] = (short)(height - 1);
                            }
                        }
                    }
                }
            }
        }
        return new ChunkHeightmap(heightmapSurface, heightmapOcean, heightmapSurfaceFloor);
    }

    private BlockSource getBaseBlockSource(NoiseSampler noiseSampler, Beardifier weightSampler, Aquifer aquiferSampler) {
        SimpleNoisePos noisePos = new SimpleNoisePos();
        return (x, y, z) -> {
            double density = noiseSampler.sample();
            double clampedDensity = Mth.clamp((double)(density / 200.0), (double)-1.0, (double)1.0);
            clampedDensity = clampedDensity / 2.0 - clampedDensity * clampedDensity * clampedDensity / 24.0;
            return aquiferSampler.computeSubstance((DensityFunction.FunctionContext)noisePos, clampedDensity += weightSampler.compute((DensityFunction.FunctionContext)noisePos.set(x, y, z)));
        };
    }

    private NoiseSettings getNoiseSettings() {
        return ((NoiseGeneratorSettings)this.generatorSettings.value()).noiseSettings();
    }
}

