/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.level.chunk.surface;

import java.util.LinkedHashMap;
import java.util.Map;
import mod.bluestaggo.modernerbeta.api.level.chunk.surface.SurfaceConfig;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;

public class SurfaceBuilder {
    private final Map<Holder<Biome>, SurfaceConfig> surfaceConfigs = new LinkedHashMap<Holder<Biome>, SurfaceConfig>();
    private final HolderLookup<SurfaceConfig> surfaceConfigRegistry;

    public SurfaceBuilder(BiomeSource biomeSource, HolderLookup<SurfaceConfig> surfaceConfigRegistry) {
        this.surfaceConfigRegistry = surfaceConfigRegistry;
        this.initMap(biomeSource, surfaceConfigRegistry);
    }

    public SurfaceConfig getSurfaceConfig(Holder<Biome> biome) {
        return this.surfaceConfigs.computeIfAbsent(biome, k -> SurfaceConfig.getSurfaceConfig(biome, this.surfaceConfigRegistry));
    }

    private void initMap(BiomeSource biomeSource, HolderLookup<SurfaceConfig> surfaceConfigRegistry) {
        biomeSource.possibleBiomes().stream().forEach(biome -> this.surfaceConfigs.put((Holder<Biome>)biome, SurfaceConfig.getSurfaceConfig((Holder<Biome>)biome, surfaceConfigRegistry)));
    }
}

