/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.optioncallbacks;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.graphical.ModernBetaSelectBiomeScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.NotNull;

public record BiomePickerCallbacks(Consumer<Screen> screenChangeHandler, Screen parentScreen, WorldCreationContext generatorOptionsHolder, boolean allowNone) implements OptionInstance.ValueSet<String>
{
    @NotNull
    public Function<OptionInstance<String>, AbstractWidget> createButton(OptionInstance.TooltipSupplier<String> tooltipFactory, Options gameOptions, int x, int y, int width, Consumer<String> changeCallback) {
        return option -> {
            ResourceLocation biomeId = ResourceLocation.tryParse((String)((String)option.get()));
            if (biomeId == null) {
                biomeId = Biomes.PLAINS.location();
            }
            String biomeTranslationKey = biomeId.toLanguageKey("biome");
            return Button.builder((Component)("".equals(option.get()) ? Component.translatable((String)"gui.none").withStyle(ChatFormatting.ITALIC) : (Language.getInstance().has(biomeTranslationKey) ? Component.translatable((String)biomeTranslationKey) : Component.literal((String)biomeId.toString()))), onPress -> this.screenChangeHandler.accept(new ModernBetaSelectBiomeScreen(this.parentScreen, this.generatorOptionsHolder, biome -> {
                if (biome != null) {
                    ResourceKey key = biome.unwrapKey().orElse(Biomes.PLAINS);
                    option.set((Object)key.location().toString());
                } else if (this.allowNone) {
                    option.set((Object)"");
                } else {
                    option.set((Object)Biomes.PLAINS.location().toString());
                }
            }, this.allowNone))).bounds(x, y, width, 20).build();
        };
    }

    @NotNull
    public Optional<String> validateValue(String value) {
        return this.allowNone && "".equals(value) || this.generatorOptionsHolder.worldgenLoadContext().lookupOrThrow(Registries.BIOME).containsKey(ResourceLocation.tryParse((String)value)) ? Optional.of(value) : Optional.empty();
    }

    @NotNull
    public Codec<String> codec() {
        return Codec.STRING;
    }
}

