/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class ModernBetaScreen
extends Screen {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_LENGTH = 150;
    public static final int BUTTON_LENGTH_PRESET = 200;
    public static final int BUTTON_HEIGHT_PRESET = 20;
    protected final ThreePartLayout layout;
    protected final Screen parent;

    public ModernBetaScreen(Component title, Screen parent) {
        this(title, parent, 33);
    }

    public ModernBetaScreen(Component title, Screen parent, int headerAndFooterHeight) {
        this(title, parent, headerAndFooterHeight, headerAndFooterHeight);
    }

    public ModernBetaScreen(Component title, Screen parent, int headerHeight, int footerHeight) {
        super(title);
        this.parent = parent;
        this.layout = new ThreePartLayout(this, headerHeight, footerHeight);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    protected void init() {
        GridLayout header = this.createGridWidget();
        this.initHeader(header);
        this.layout.addToHeader(header);
        GridLayout content = this.createGridWidget();
        this.initContent(content);
        this.layout.addToContents(content);
        GridLayout footer = this.createGridWidget();
        this.initFooter(footer);
        this.layout.addToFooter(footer);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void initHeader(GridLayout headerLayout) {
        headerLayout.addChild((LayoutElement)new StringWidget(this.getTitle(), this.font), 0, 0);
    }

    protected abstract void initContent(GridLayout var1);

    protected abstract void initFooter(GridLayout var1);

    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    protected GridLayout createGridWidget() {
        GridLayout gridWidget = new GridLayout();
        gridWidget.defaultCellSetting().paddingHorizontal(5).paddingBottom(4).alignHorizontallyCenter().alignVerticallyTop();
        return gridWidget;
    }

    protected void addGridTextButtonPair(GridLayout.RowHelper adder, String text, Button buttonWidget) {
        adder.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)text), this.font));
        adder.addChild((LayoutElement)buttonWidget);
    }

    protected void addGridTextButtonTriplet(GridLayout.RowHelper adder, String text, Button buttonWidget, Button buttonWidget2) {
        adder.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)text), this.font));
        adder.addChild((LayoutElement)buttonWidget);
        adder.addChild((LayoutElement)buttonWidget2);
    }

    protected static class ThreePartLayout
    implements Layout {
        private final FrameLayout headerFrame = new FrameLayout();
        private final FrameLayout footerFrame = new FrameLayout();
        private final FrameLayout contentsFrame = new FrameLayout();
        private final Screen screen;
        private int headerHeight;
        private int footerHeight;
        private int contentMarginTop = 30;

        public ThreePartLayout(Screen screen, int headerHeight, int footerHeight) {
            this.screen = screen;
            this.headerHeight = headerHeight;
            this.footerHeight = footerHeight;
            this.headerFrame.defaultChildLayoutSetting().align(0.5f, 0.5f);
            this.footerFrame.defaultChildLayoutSetting().align(0.5f, 0.5f);
        }

        public void setX(int x) {
        }

        public void setY(int y) {
        }

        public int getX() {
            return 0;
        }

        public int getY() {
            return 0;
        }

        public int getWidth() {
            return this.screen.width;
        }

        public int getHeight() {
            return this.screen.height;
        }

        public int getFooterHeight() {
            return this.footerHeight;
        }

        public void setFooterHeight(int footerHeight) {
            this.footerHeight = footerHeight;
        }

        public void setHeaderHeight(int headerHeight) {
            this.headerHeight = headerHeight;
        }

        public void setContentMarginTop(int marginTop) {
            this.contentMarginTop = marginTop;
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public int getContentHeight() {
            return this.screen.height - this.getHeaderHeight() - this.getFooterHeight();
        }

        public void visitChildren(Consumer<LayoutElement> visitor) {
            this.headerFrame.visitChildren(visitor);
            this.contentsFrame.visitChildren(visitor);
            this.footerFrame.visitChildren(visitor);
        }

        public void arrangeElements() {
            int headHeight = this.getHeaderHeight();
            int footHeight = this.getFooterHeight();
            this.headerFrame.setMinWidth(this.screen.width);
            this.headerFrame.setMinHeight(headHeight);
            this.headerFrame.setPosition(0, 0);
            this.headerFrame.arrangeElements();
            this.footerFrame.setMinWidth(this.screen.width);
            this.footerFrame.setMinHeight(footHeight);
            this.footerFrame.arrangeElements();
            this.footerFrame.setY(this.screen.height - footHeight);
            this.contentsFrame.setMinWidth(this.screen.width);
            this.contentsFrame.arrangeElements();
            int contentMin = headHeight + this.contentMarginTop;
            int contentMax = this.screen.height - footHeight - this.contentsFrame.getHeight();
            this.contentsFrame.setPosition(0, Math.min(contentMin, contentMax));
        }

        public <T extends LayoutElement> T addToHeader(T child) {
            return (T)this.headerFrame.addChild(child);
        }

        public <T extends LayoutElement> T addToFooter(T child) {
            return (T)this.footerFrame.addChild(child);
        }

        public <T extends LayoutElement> T addToContents(T child) {
            return (T)this.contentsFrame.addChild(child);
        }

        public <T extends LayoutElement> T addToHeader(T child, Consumer<LayoutSettings> layoutSettingsFactory) {
            return (T)this.headerFrame.addChild(child, layoutSettingsFactory);
        }

        public <T extends LayoutElement> T addToFooter(T child, Consumer<LayoutSettings> layoutSettingsFactory) {
            return (T)this.footerFrame.addChild(child, layoutSettingsFactory);
        }

        public <T extends LayoutElement> T addToContents(T child, Consumer<LayoutSettings> layoutSettingFactory) {
            return (T)this.contentsFrame.addChild(child, layoutSettingFactory);
        }
    }
}

