/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaSettingsPresetScreen;
import mod.bluestaggo.modernerbeta.registry.ModernBetaResourceKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPresetCategory;
import mod.bluestaggo.modernerbeta.tags.ModernBetaSettingsPresetCategoryTags;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.DetectedVersion;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataProvider;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModernBetaDataPackExportScreen
extends ModernBetaScreen {
    public static final int TEXT_BOX_LENGTH = 227;
    private static final String TEXT_PRESET_CATEGORY = "createWorld.customize.modern_beta.preset_category";
    private static final String TEXT_PRESET_CATEGORY_NAME = "createWorld.customize.modern_beta.preset_category.name";
    private static final String DATA_PACK_EXPORT_PRESET_ID = "createWorld.customize.modern_beta.settings.data_pack_export.preset_id";
    private static final String DATA_PACK_EXPORT_PRESET_NAME = "createWorld.customize.modern_beta.settings.data_pack_export.preset_name";
    private static final String DATA_PACK_EXPORT_PRESET_DESCRIPTION = "createWorld.customize.modern_beta.settings.data_pack_export.preset_description";
    private static final String DATA_PACK_EXPORT = "createWorld.customize.modern_beta.settings.data_pack_export.export";
    private static final String DATA_PACK_EXPORT_SAVE_AS_TITLE = "createWorld.customize.modern_beta.settings.data_pack_export.save_as_title";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Moderner Beta");
    private final Registry<ModernBetaSettingsPreset> presetRegistry;
    private final Registry<ModernBetaSettingsPresetCategory> presetCategoryRegistry;
    private final RegistryAccess registries;
    private final ModernBetaSettingsPreset preset;
    private ResourceLocation presetID;
    private String presetName = "";
    private String presetDescription = "";
    private ResourceLocation presetCategory;
    private EditBox idBox;
    private EditBox nameBox;
    private MultiLineEditBox descriptionBox;
    private Button exportButton;
    private Button categoryButton;

    public ModernBetaDataPackExportScreen(String title, Screen parent, ModernBetaSettingsPreset preset, RegistryAccess registries) {
        super((Component)Component.translatable((String)title), parent);
        this.layout.setContentMarginTop(0);
        this.preset = preset;
        this.presetRegistry = registries.lookupOrThrow(ModernBetaResourceKeys.SETTINGS_PRESET);
        this.presetCategoryRegistry = registries.lookupOrThrow(ModernBetaResourceKeys.SETTINGS_PRESET_CATEGORY);
        this.registries = registries;
    }

    @Override
    protected void init() {
        assert (this.minecraft != null);
        if (this.presetID == null) {
            this.presetID = this.getDefaultPresetID();
        }
        super.init();
    }

    @Override
    protected void initContent(GridLayout contentLayout) {
        GridLayout gridWidgetOptions = this.createGridWidget();
        GridLayout.RowHelper mainContent = contentLayout.createRowHelper(1);
        GridLayout.RowHelper optionsContent = gridWidgetOptions.createRowHelper(2);
        optionsContent.defaultCellSetting().alignHorizontallyRight().alignVerticallyMiddle();
        this.categoryButton = Button.builder((Component)this.getCategoryButtonLabel(), button -> this.minecraft.setScreen(new ModernBetaSettingsPresetScreen(this, this.presetCategoryRegistry.getOrThrow(ModernBetaSettingsPresetCategoryTags.SELECTABLE).stream().toList(), (screen, category, preset) -> {
            this.presetCategory = category;
            this.categoryButton.setMessage(this.getCategoryButtonLabel());
            screen.onClose();
        }, false))).size(200, 20).build();
        MutableComponent idText = Component.translatable((String)DATA_PACK_EXPORT_PRESET_ID);
        StringWidget idLabel = new StringWidget((Component)idText, this.font);
        this.idBox = new EditBox(this.minecraft.fontFilterFishy, 0, 0, 227, 20, (Component)Component.empty());
        this.idBox.setValue(this.presetID.toString());
        this.idBox.setResponder(string -> {
            ResourceLocation parsed = ResourceLocation.tryParse((String)string);
            if (parsed != null) {
                this.idBox.setTextColor(0xE0E0E0);
            } else {
                this.idBox.setTextColor(ChatFormatting.RED.getColor() | 0xFF000000);
            }
            this.presetID = parsed;
            this.exportButton.active = this.canExport();
        });
        MutableComponent nameText = Component.translatable((String)DATA_PACK_EXPORT_PRESET_NAME);
        StringWidget nameLabel = new StringWidget((Component)nameText, this.font);
        this.nameBox = new EditBox(this.minecraft.fontFilterFishy, 0, 0, 227, 20, (Component)Component.empty());
        this.nameBox.setValue(this.presetName);
        this.nameBox.setResponder(string -> {
            this.presetName = string;
            this.exportButton.active = this.canExport();
        });
        MutableComponent descriptionText = Component.translatable((String)DATA_PACK_EXPORT_PRESET_DESCRIPTION);
        StringWidget descriptionLabel = new StringWidget((Component)descriptionText, this.font);
        this.descriptionBox = new MultiLineEditBox(this.font, 0, 0, 227, 60, (Component)Component.literal((String)""), (Component)Component.literal((String)""));
        this.descriptionBox.setValue(this.presetDescription);
        this.descriptionBox.setCharacterLimit(175);
        this.descriptionBox.setValueListener(string -> {
            this.presetDescription = string;
            this.exportButton.active = this.canExport();
        });
        mainContent.addChild((LayoutElement)this.categoryButton);
        mainContent.addChild((LayoutElement)gridWidgetOptions);
        optionsContent.addChild((LayoutElement)idLabel);
        optionsContent.addChild((LayoutElement)this.idBox);
        optionsContent.addChild((LayoutElement)nameLabel);
        optionsContent.addChild((LayoutElement)this.nameBox);
        LayoutSettings layoutSettings = optionsContent.newCellSettings().alignVerticallyTop().paddingTop(6);
        optionsContent.addChild((LayoutElement)descriptionLabel, 1, layoutSettings);
        optionsContent.addChild((LayoutElement)this.descriptionBox, 1, layoutSettings.copy().paddingTop(0));
    }

    @Override
    protected void initFooter(GridLayout footerLayout) {
        GridLayout.RowHelper footerContent = footerLayout.createRowHelper(2);
        this.exportButton = Button.builder((Component)Component.translatable((String)DATA_PACK_EXPORT), button -> {
            Language language = Language.getInstance();
            String title = language.getOrDefault(DATA_PACK_EXPORT_SAVE_AS_TITLE);
            File path = new File(this.minecraft.gameDirectory, this.presetID.getPath());
            String writeTo = ModernBetaDataPackExportScreen.getOutputPathFromSelection(path, title, "*.zip");
            this.exportDatapack(writeTo);
        }).size(150, 20).build();
        this.exportButton.active = false;
        Button widgetCancel = Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(this.parent)).size(150, 20).build();
        footerContent.addChild((LayoutElement)this.exportButton);
        footerContent.addChild((LayoutElement)widgetCancel);
    }

    private ResourceLocation getDefaultPresetID() {
        assert (this.minecraft != null);
        String playerName = this.minecraft.getUser().getName().toLowerCase(Locale.ROOT);
        return VersionCompat.id(playerName, "custom_preset");
    }

    private boolean canExport() {
        return this.presetID != null && !this.nameBox.getValue().isEmpty() && !this.descriptionBox.getValue().isEmpty();
    }

    private Component getCategoryButtonLabel() {
        MutableComponent category = Component.translatable((String)TEXT_PRESET_CATEGORY).append(": ");
        category.append((Component)(this.presetCategory == null ? Component.translatable((String)"gui.none").withStyle(ChatFormatting.AQUA) : Component.translatable((String)("createWorld.customize.modern_beta.preset_category.name." + this.presetCategory.toLanguageKey())).withStyle(ChatFormatting.YELLOW)));
        return category;
    }

    private <T> JsonElement objectToJson(T value, Codec<T> codec) {
        return this.objectToJson(value, codec, false);
    }

    private <T> JsonElement objectToJson(T value, Codec<T> codec, boolean registries) {
        JsonOps ops = registries ? RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registries) : JsonOps.INSTANCE;
        DataResult result = codec.encodeStart((DynamicOps)ops, value);
        return (JsonElement)VersionCompat.getOrThrow(result);
    }

    private static String getOutputPathFromSelection(File path, String title, String ... filterPatterns) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pointers = stack.mallocPointer(filterPatterns.length);
            for (String pattern : filterPatterns) {
                pointers.put(stack.UTF8((CharSequence)pattern));
                pointers.flip();
            }
            String string = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)path.toString(), (PointerBuffer)pointers, null);
            return string;
        }
    }

    private void exportDatapack(String outputPath) {
        if (outputPath == null) {
            return;
        }
        try (DataPackExporter exporter = new DataPackExporter(outputPath);){
            if (this.presetCategory != null) {
                ModernBetaSettingsPresetCategory category = (ModernBetaSettingsPresetCategory)this.presetCategoryRegistry.getValue(this.presetCategory);
                TagKey<ModernBetaSettingsPreset> tagKey = category.presetTag();
                FileToIdConverter converter = FileToIdConverter.json((String)VersionCompat.tagsDirPath(ModernBetaResourceKeys.SETTINGS_PRESET));
                ResourceLocation pathLocation = converter.idToFile(tagKey.location());
                TagFile tagFile = new TagFile(List.of(TagEntry.element((ResourceLocation)this.presetID)), false);
                exporter.addJson(this.objectToJson(tagFile, TagFile.CODEC), "data", pathLocation);
            }
            FileToIdConverter converter = FileToIdConverter.json((String)VersionCompat.elementsDirPath(ModernBetaResourceKeys.SETTINGS_PRESET));
            ResourceLocation pathLocation = converter.idToFile(this.presetID);
            ModernBetaSettingsPreset expanded = this.preset.mapped((HolderGetter<ModernBetaSettingsPreset>)this.presetRegistry).withNameAndDesc((Component)Component.literal((String)this.presetName).withStyle(ChatFormatting.YELLOW), (Component)Component.literal((String)this.presetDescription));
            exporter.addJson(this.objectToJson(expanded, ModernBetaSettingsPreset.CODEC, true), "data", pathLocation);
            PackMetadataSection metadataSection = new PackMetadataSection((Component)Component.literal((String)"Moderner Beta exported preset"), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA), Optional.empty());
            JsonElement metadataElement = this.objectToJson(metadataSection, PackMetadataSection.CODEC);
            JsonObject packObject = new JsonObject();
            packObject.add("pack", metadataElement);
            exporter.addJson((JsonElement)packObject, "pack.mcmeta");
        }
        catch (Exception e) {
            LOGGER.error("Failed to export datapack!", (Throwable)e);
        }
    }

    private static class DataPackExporter
    implements AutoCloseable {
        private final ZipOutputStream stream;

        public DataPackExporter(String path) {
            FileOutputStream fileOutputStream;
            try {
                fileOutputStream = new FileOutputStream(path);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.stream = new ZipOutputStream(fileOutputStream);
        }

        private void addJson(JsonElement json, String parent, ResourceLocation path) throws IOException {
            this.addJson(json, parent, path.getNamespace() + "/" + path.getPath());
        }

        private void addJson(JsonElement json, ResourceLocation path) throws IOException {
            this.addJson(json, "", path);
        }

        private void addJson(JsonElement json, String path) throws IOException {
            this.addJson(json, "", path);
        }

        private void addJson(JsonElement json, String parent, String path) throws IOException {
            ZipEntry entry = new ZipEntry((String)(!parent.isEmpty() ? parent + "/" : "") + path);
            byte[] b = new byte[]{};
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                 JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));){
                jsonWriter.setSerializeNulls(false);
                jsonWriter.setIndent("  ");
                GsonHelper.writeValue((JsonWriter)jsonWriter, (JsonElement)json, (Comparator)DataProvider.KEY_COMPARATOR);
                jsonWriter.flush();
                b = outputStream.toByteArray();
            }
            catch (IOException var10) {
                LOGGER.error("Failed to save JSON file {}", (Object)path, (Object)var10);
            }
            this.stream.putNextEntry(entry);
            this.stream.write(b);
        }

        @Override
        public void close() throws Exception {
            this.stream.close();
        }
    }
}

