/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen.config.graphical;

import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.CustomButtonCallbacks;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.TextLabelCallbacks;
import mod.bluestaggo.modernerbeta.imixin.ModernBetaClearableWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.locale.Language;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class ModernBetaGraphicalSettingsScreen<T extends Tag>
extends OptionsSubScreen {
    protected static final String STRING_PREFIX = "createWorld.customize.modern_beta.settings.";
    protected final T settings;
    protected final WorldCreationContext context;
    protected final Consumer<T> onDone;
    protected final String type;
    private double prevScroll = -1.0;

    public ModernBetaGraphicalSettingsScreen(String title, Screen parent, WorldCreationContext context, String type, T settings, Consumer<T> onDone) {
        super(parent, null, (Component)Component.translatable((String)title));
        this.onDone = onDone;
        this.type = type;
        this.settings = settings;
        this.context = context;
    }

    protected abstract void addOptions(OptionsList var1);

    protected void addOptions() {
    }

    public void removed() {
    }

    public void onClose() {
        this.minecraft.setScreen(null);
    }

    protected void clearWidgets() {
        if (this.list != null) {
            this.prevScroll = this.list.scrollAmount();
        }
        super.clearWidgets();
        ((ModernBetaClearableWidget)this.layout).modernBeta$clear();
    }

    protected void addContents() {
        this.list = (OptionsList)this.layout.addToContents((LayoutElement)new OptionsList(this.minecraft, this.width, (OptionsSubScreen)this));
        this.addOptions(this.list);
        if (this.prevScroll >= 0.0 && this.list != null) {
            this.list.setScrollAmount(this.prevScroll);
        }
    }

    protected void addFooter() {
        GridLayout gridWidget = new GridLayout().columnSpacing(8);
        GridLayout.RowHelper gridWidgetAdder = gridWidget.createRowHelper(2);
        gridWidgetAdder.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.save"), onPress -> {
            this.onDone.accept(this.getResult());
            this.minecraft.setScreen(this.lastScreen);
        }).bounds(this.width / 2 - 155, this.height - 28, 150, 20).build());
        gridWidgetAdder.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, onPress -> this.minecraft.setScreen(this.lastScreen)).bounds(this.width / 2 + 5, this.height - 28, 150, 20).build());
        this.layout.addToFooter((LayoutElement)gridWidget);
    }

    protected T getResult() {
        return this.settings;
    }

    protected String getTextKey(String key) {
        return this.getTextKey(key, (String)null);
    }

    protected String getTextKey(String key, String subKey) {
        Object text = STRING_PREFIX;
        if (this.type != null) {
            text = (String)text + this.type + ".";
        }
        text = (String)text + key;
        if (subKey != null) {
            text = (String)text + "." + subKey;
        }
        return text;
    }

    protected String getTextKey(String key, ResourceLocation subKey) {
        return this.getTextKey(key, subKey != null ? subKey.getPath() : null);
    }

    protected static <T> OptionInstance.TooltipSupplier<T> getTooltip(String key) {
        key = (String)key + ".desc";
        if (!Language.getInstance().has((String)key)) {
            return OptionInstance.noTooltip();
        }
        return OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)key));
    }

    public MutableComponent getText(String key) {
        return this.getText(key, (String)null);
    }

    public MutableComponent getText(String key, String subKey) {
        return Component.translatable((String)this.getTextKey(key, subKey));
    }

    public MutableComponent getText(String key, ResourceLocation subKey) {
        return Component.translatable((String)this.getTextKey(key, subKey));
    }

    public OptionInstance<Void> headerOption(Component text) {
        return this.headerOption(text, 0.5f);
    }

    public OptionInstance<Void> headerOption(Component text, float alignment) {
        return new OptionInstance("", OptionInstance.noTooltip(), (optionText, value) -> text, (OptionInstance.ValueSet)new TextLabelCallbacks(text, alignment), null, value -> {});
    }

    public OptionInstance<Void> placeholderOption(String key) {
        return this.headerOption((Component)this.getText(key).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
    }

    public OptionInstance<Void> customButton(Component text, Runnable onPress) {
        return new OptionInstance("", OptionInstance.noTooltip(), (optionText, value) -> Component.empty(), (OptionInstance.ValueSet)new CustomButtonCallbacks(text, onPress), null, value -> {});
    }
}

