/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen.config.graphical;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.Nullable;

public class ModernBetaSelectBiomeScreen
extends ModernBetaScreen {
    private static final Component SEARCH_HINT = Component.translatable((String)"createWorld.customize.modern_beta.search").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    private final Consumer<Holder<Biome>> onDone;
    private final boolean allowNone;
    final Registry<Biome> biomeRegistry;
    private BiomeList biomeSelectionList;
    Holder<Biome> biome;
    private Button confirmButton;

    public ModernBetaSelectBiomeScreen(Screen parent, WorldCreationContext context, Consumer<Holder<Biome>> onDone, boolean allowNone) {
        super((Component)Component.translatable((String)"createWorld.customize.modern_beta.title.biome_picker"), parent, 40, 33);
        this.onDone = onDone;
        this.allowNone = allowNone;
        this.biomeRegistry = context.worldgenLoadContext().lookupOrThrow(Registries.BIOME);
        Holder registryEntry = (Holder)this.biomeRegistry.get(Biomes.PLAINS).or(() -> this.biomeRegistry.listElements().findAny()).orElseThrow();
        this.biome = context.selectedDimensions().overworld().getBiomeSource().possibleBiomes().stream().findFirst().orElse(registryEntry);
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    @Override
    protected void init() {
        this.biomeSelectionList = new BiomeList();
        super.init();
        this.biomeSelectionList.setSelected((BiomeList.Entry)this.biomeSelectionList.children().stream().filter(entry -> Objects.equals(entry.biome, this.biome)).findFirst().orElse(null));
    }

    @Override
    protected void initHeader(GridLayout headerLayout) {
        headerLayout.columnSpacing(3);
        headerLayout.defaultCellSetting().paddingVertical(3);
        super.initHeader(headerLayout);
        EditBox editBox = (EditBox)headerLayout.addChild((LayoutElement)new EditBox(this.font, 0, 0, 200, 15, (Component)Component.empty()), 1, 0);
        editBox.setHint(SEARCH_HINT);
        editBox.setResponder(this.biomeSelectionList::filterEntries);
    }

    @Override
    protected void initContent(GridLayout contentLayout) {
        this.layout.addToContents(this.biomeSelectionList);
    }

    @Override
    protected void initFooter(GridLayout footerLayout) {
        GridLayout.RowHelper row = footerLayout.createRowHelper(2);
        this.confirmButton = (Button)row.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.onDone.accept(this.biome);
            this.onClose();
        }).build());
        row.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).build());
    }

    @Override
    protected void repositionElements() {
        super.repositionElements();
        this.biomeSelectionList.setSize(this.width, this.layout.getContentHeight());
        this.biomeSelectionList.setPosition(0, this.layout.getHeaderHeight());
        this.biomeSelectionList.refreshScrollAmount();
    }

    void refreshConfirmButton() {
        this.confirmButton.active = this.biomeSelectionList.getSelected() != null;
    }

    class BiomeList
    extends ObjectSelectionList<Entry> {
        BiomeList() {
            super(ModernBetaSelectBiomeScreen.this.minecraft, ModernBetaSelectBiomeScreen.this.width, ModernBetaSelectBiomeScreen.this.layout.getContentHeight(), ModernBetaSelectBiomeScreen.this.layout.getHeaderHeight(), 15);
            this.filterEntries("");
        }

        private void filterEntries(String filter) {
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());
            String query = filter.toLowerCase(Locale.ROOT);
            this.clearEntries();
            if (ModernBetaSelectBiomeScreen.this.allowNone) {
                this.addEntry((AbstractSelectionList.Entry)new Entry());
            }
            ModernBetaSelectBiomeScreen.this.biomeRegistry.listElements().map(x$0 -> new Entry((Holder.Reference<Biome>)x$0)).sorted(Comparator.comparing(entry -> entry.text.getString(), collator)).filter(entry -> filter.isEmpty() || entry.text.getString().toLowerCase(Locale.ROOT).contains(query)).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
            this.refreshScrollAmount();
        }

        public void setSelected(@Nullable Entry entry) {
            super.setSelected((AbstractSelectionList.Entry)entry);
            if (entry != null) {
                ModernBetaSelectBiomeScreen.this.biome = entry.biome;
            }
            ModernBetaSelectBiomeScreen.this.refreshConfirmButton();
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            final Holder.Reference<Biome> biome;
            final Component text;

            public Entry() {
                this.biome = null;
                this.text = Component.translatable((String)"gui.none").withStyle(ChatFormatting.ITALIC);
            }

            public Entry(Holder.Reference<Biome> biome) {
                this.biome = biome;
                ResourceLocation id = biome.key().location();
                String name = id.toLanguageKey("biome");
                this.text = Language.getInstance().has(name) ? Component.translatable((String)name) : Component.literal((String)id.toString());
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.text});
            }

            public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                graphics.drawString(ModernBetaSelectBiomeScreen.this.font, this.text, x + 5, y + 2, -1);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                BiomeList.this.setSelected(this);
                return super.mouseClicked(mouseX, mouseY, button);
            }
        }
    }
}

