/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.resource;

import java.io.IOException;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import net.minecraft.client.resources.LegacyStuffWrapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ModernBetaColormapReloadListener
extends SimplePreparableReloadListener<int[]> {
    private final ResourceLocation id;
    private final Consumer<int[]> consumer;

    public ModernBetaColormapReloadListener(String path, Consumer<int[]> consumer) {
        this.id = ModernerBeta.createId(path);
        this.consumer = consumer;
    }

    @NotNull
    protected int[] prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        try {
            return LegacyStuffWrapper.getPixels((ResourceManager)resourceManager, (ResourceLocation)this.id);
        }
        catch (IOException exception) {
            throw new IllegalStateException("[Modern Beta] Failed to load colormap texture!", exception);
        }
    }

    protected void apply(int[] object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.consumer.accept(object);
    }
}

