/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class DebugProviderSettingsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"printprovidersettings").requires(source -> source.hasPermission(2))).executes(ctx -> DebugProviderSettingsCommand.execute((CommandSourceStack)ctx.getSource())));
    }

    private static int execute(CommandSourceStack source) {
        boolean validWorld = false;
        ChunkGenerator chunkGenerator = source.getLevel().getChunkSource().getGenerator();
        if (chunkGenerator instanceof ModernBetaChunkGenerator) {
            ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
            validWorld = true;
            source.sendSuccess(() -> Component.literal((String)"Chunk Provider Settings:").withStyle(ChatFormatting.YELLOW), false);
            source.sendSuccess(() -> Component.literal((String)modernBetaChunkGenerator.getChunkSettings().toString()), false);
        }
        if ((chunkGenerator = source.getLevel().getChunkSource().getGenerator().getBiomeSource()) instanceof ModernBetaBiomeSource) {
            ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)chunkGenerator;
            validWorld = true;
            source.sendSuccess(() -> Component.literal((String)"Biome Provider Settings:").withStyle(ChatFormatting.YELLOW), false);
            source.sendSuccess(() -> Component.literal((String)modernBetaBiomeSource.getBiomeSettings().toString()), false);
            source.sendSuccess(() -> Component.literal((String)"Cave Biome Provider Settings:").withStyle(ChatFormatting.YELLOW), false);
            source.sendSuccess(() -> Component.literal((String)modernBetaBiomeSource.getCaveBiomeSettings().toString()), false);
        }
        if (validWorld) {
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"Not a Modern Beta world!").withStyle(ChatFormatting.RED), false);
        return -1;
    }
}

