/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.compat.levelgen;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import mod.bluestaggo.modernerbeta.compat.levelgen.LevelGenCompatHelper;

public class ValkyrienSkiesCompat
implements LevelGenCompatHelper {
    private final Object chunkAllocator;
    private final Method isChunkInShipyardMethod;

    public ValkyrienSkiesCompat() {
        try {
            Class<?> allocatorClass = Class.forName("org.valkyrienskies.mod.common.VS2ChunkAllocator");
            Field instanceField = allocatorClass.getField("INSTANCE");
            this.chunkAllocator = instanceField.get(null);
            this.isChunkInShipyardMethod = allocatorClass.getMethod("isChunkInShipyardCompanion", Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialise Valkyrien Skies compatibility!", e);
        }
    }

    @Override
    public boolean skipGeneratingChunk(int x, int z) {
        try {
            return (Boolean)this.isChunkInShipyardMethod.invoke(this.chunkAllocator, x, z);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

