/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.forgelike;

import java.util.List;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.compat.ModCompat;
import mod.bluestaggo.modernerbeta.forgelike.FMLUtils;
import mod.bluestaggo.modernerbeta.forgelike.mixin.DataPackRegistriesHooksAccessor;
import mod.bluestaggo.modernerbeta.forgelike.network.NetworkHelperImpl;
import mod.bluestaggo.modernerbeta.forgelike.registry.RegistryHelperImpl;
import mod.bluestaggo.modernerbeta.network.BiomeProviderInfoPayload;
import mod.bluestaggo.modernerbeta.network.S2CPacketHandlers;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.VanillaRegistryHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.ModifyRegistriesEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="moderner_beta", bus=EventBusSubscriber.Bus.MOD)
public class ModEventsCommon {
    @SubscribeEvent
    public static void commonInit(FMLConstructModEvent event) {
        ModernerBeta.init();
        ModCompat.initialise(FMLUtils::isModPresent);
        if (!FMLLoader.isProduction()) {
            ModernerBeta.DEV_ENV = true;
        }
    }

    @SubscribeEvent
    public static void postInit(FMLLoadCompleteEvent event) {
        ModernerBeta.loadConfig(FMLPaths.CONFIGDIR.get());
    }

    @SubscribeEvent
    public static void registerToRegistries(RegisterEvent event) {
        Registry registry = event.getRegistry();
        VanillaRegistryHandler registryHandler = new VanillaRegistryHandler(registry);
        ModernerBeta.REGISTRY_HANDLERS.stream().filter(pair -> ((Registry)pair.getA()).key().equals(event.getRegistryKey())).forEach(pair -> ((Consumer)pair.getB()).accept(registryHandler));
        ModernerBeta.CUSTOM_REGISTRY_HANDLERS.stream().filter(pair -> ((Registry)pair.getA()).key().equals(event.getRegistryKey())).forEach(pair -> ((Consumer)pair.getB()).accept(registryHandler));
    }

    @SubscribeEvent
    public static void registerRegistries(NewRegistryEvent event) {
        RegistryHelperImpl registryHelper = new RegistryHelperImpl(event);
        ModernBetaRegistries.makeRegistries(registryHelper);
        ModernerBeta.setupCustomRegistryHandlers();
    }

    @SubscribeEvent
    public static void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        ModernerBeta.setupCustomDynamicRegistries();
        for (ModernerBeta.CustomDynamicRegistry<?> dynamicRegistry : ModernerBeta.CUSTOM_DYNAMIC_REGISTRIES) {
            event.dataPackRegistry(dynamicRegistry.key(), dynamicRegistry.codec());
        }
    }

    @SubscribeEvent
    public static void modifyRegistries(ModifyRegistriesEvent event) {
        List<RegistryDataLoader.RegistryData<?>> dataPackRegistries = DataPackRegistriesHooksAccessor.getDataPackRegistries();
        for (ModernerBeta.CustomDynamicRegistry<?> dynamicRegistry : ModernerBeta.CUSTOM_DYNAMIC_REGISTRIES) {
            if (dynamicRegistry.insertAfter() == null) continue;
            RegistryDataLoader.RegistryData registryData = dataPackRegistries.stream().filter(data -> data.key() == dynamicRegistry.key()).findFirst().orElseThrow();
            dataPackRegistries.remove(registryData);
            int index = dataPackRegistries.stream().filter(data -> data.key() == dynamicRegistry.insertAfter()).map(dataPackRegistries::indexOf).findFirst().orElseThrow();
            dataPackRegistries.add(index, registryData);
        }
    }

    @SubscribeEvent
    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        ModernerBeta.networkHelper = new NetworkHelperImpl();
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(BiomeProviderInfoPayload.ID, BiomeProviderInfoPayload.CODEC, (payload, context) -> S2CPacketHandlers.onBiomeProviderInfo(context.player().level(), payload));
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            PackSource source = new PackSource(){

                public Component decorate(Component packDisplayName) {
                    return Component.translatable((String)"pack.nameAndSource", (Object[])new Object[]{packDisplayName, Component.translatable((String)"pack.source.builtin")}).withStyle(ChatFormatting.GRAY);
                }

                public boolean shouldAddAutomatically() {
                    return false;
                }
            };
            for (String pack : ModernerBeta.BUILT_IN_PACKS) {
                MutableComponent title = Component.translatable((String)("dataPack.moderner_beta." + pack + ".name"));
                event.addPackFinders(ModernerBeta.createId("resourcepacks/" + pack), PackType.SERVER_DATA, (Component)title, source, false, Pack.Position.TOP);
            }
        }
    }
}

