/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level;

import mod.bluestaggo.modernerbeta.api.level.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.imixin.ModernBetaLevel;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;

public class ModernBetaLevelInitializer {
    public static void initStarting(MinecraftServer server) {
        Registry registryDimensionOptions = server.registries().compositeAccess().lookupOrThrow(Registries.LEVEL_STEM);
        long seed = server.getWorldData().worldGenOptions().seed();
        registryDimensionOptions.entrySet().forEach(entry -> {
            LevelStem dimensionOptions = (LevelStem)entry.getValue();
            ChunkGenerator chunkGenerator = dimensionOptions.generator();
            BiomeSource biomeSource = chunkGenerator.getBiomeSource();
            if (chunkGenerator instanceof ModernBetaChunkGenerator) {
                ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
                modernBetaChunkGenerator.initProvider(seed);
            }
            if (biomeSource instanceof ModernBetaBiomeSource) {
                ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource;
                modernBetaBiomeSource.initProvider(seed);
            }
        });
    }

    public static void initStarted(MinecraftServer server) {
        for (ServerLevel level : server.getAllLevels()) {
            ModernBetaChunkGenerator chunkGenerator;
            ModernBetaLevel modernBetaLevel = (ModernBetaLevel)level;
            ChunkGenerator chunkGenerator2 = level.getChunkSource().getGenerator();
            if (!(chunkGenerator2 instanceof ModernBetaChunkGenerator) || !((chunkGenerator2 = (chunkGenerator = (ModernBetaChunkGenerator)chunkGenerator2).getBiomeSource()) instanceof ModernBetaBiomeSource)) continue;
            ModernBetaBiomeSource biomeSource = (ModernBetaBiomeSource)chunkGenerator2;
            modernBetaLevel.modernerBeta$setModded(true);
            BiomeProvider biomeProvider = biomeSource.getBiomeProvider();
            if (biomeProvider instanceof ClimateSampler) {
                ClimateSampler climateSampler = (ClimateSampler)((Object)biomeProvider);
                modernBetaLevel.modernerBeta$setClimateSampler(climateSampler);
            }
            modernBetaLevel.modernerBeta$setTemperatureHeightScaling(biomeSource.getBiomeProvider().getTemperatureHeightScaling());
        }
    }
}

