/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome;

import mod.bluestaggo.modernerbeta.level.carver.configured.ModernBetaConfiguredCarvers;
import mod.bluestaggo.modernerbeta.level.feature.placed.ModernBetaMiscPlacedFeatures;
import mod.bluestaggo.modernerbeta.level.feature.placed.ModernBetaOrePlacedFeatures;
import mod.bluestaggo.modernerbeta.level.feature.placed.ModernBetaVegetationPlacedFeatures;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;

public class ModernBetaBiomeFeatures {
    public static void addDefaultVegetation(BiomeGenerationSettings.Builder builder, boolean includeNearWater) {
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)builder, (boolean)includeNearWater);
    }

    public static void addDesertFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
            BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_CACTUS_PE);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
            BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)builder);
            BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_CACTUS_DESERT);
        }
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_SUGAR_CANE_DESERT);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_PUMPKIN);
        BiomeDefaultFeatures.addDesertExtraDecoration((BiomeGenerationSettings.Builder)builder);
    }

    public static void addForestFeatures(BiomeGenerationSettings.Builder builder, boolean pe, boolean hasBirch) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, true);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_PE_FOREST);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, hasBirch ? ModernBetaVegetationPlacedFeatures.TREES_BETA_FOREST_BEES : ModernBetaVegetationPlacedFeatures.TREES_BETA_OAK_FOREST_BEES);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FOREST_FLOWERS);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_GRASS_FOREST);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, true);
    }

    public static void addIceDesertFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
    }

    public static void addPlainsFeatures(BiomeGenerationSettings.Builder builder, boolean pe, boolean earlyRelease) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : (earlyRelease ? ModernBetaFeatureSettings.EARLY_RELEASE : ModernBetaFeatureSettings.BETA));
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, true);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_3);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_PLAINS_10);
        }
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_PLAINS);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, true);
    }

    public static void addRainforestFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, true);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_PE_RAINFOREST);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_BETA_RAINFOREST_BEES);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_RAINFOREST_10);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FOREST_FLOWERS);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_MELON_SPARSE);
    }

    public static void addSavannaFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_PE_SPARSE);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_BETA_SPARSE_BEES);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
    }

    public static void addSeasonalForestFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, true);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_PE_SEASONAL_FOREST);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_4);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_BETA_SEASONAL_FOREST_BEES);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_GRASS_FOREST);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, true);
    }

    public static void addShrublandFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_PE_SPARSE);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_BETA_SPARSE_BEES);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
    }

    public static void addSkyFeatures(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.SKY);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_BETA_SPARSE);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
    }

    public static void addSwamplandFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_PE_SPARSE);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_BETA_SPARSE_BEES);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_SWAMP);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)builder);
    }

    public static void addTaigaFeatures(BiomeGenerationSettings.Builder builder, boolean pe, boolean spruce) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, true);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_PE_TAIGA);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, spruce ? ModernBetaVegetationPlacedFeatures.TREES_BETA_TAIGA : ModernBetaVegetationPlacedFeatures.TREES_BETA_OAK_FOREST);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_TAIGA_1);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, true);
        if (!pe) {
            BiomeDefaultFeatures.addCommonBerryBushes((BiomeGenerationSettings.Builder)builder);
        }
    }

    public static void addTundraFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
    }

    public static void addExtremeHillsFeatures(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.EARLY_RELEASE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_BETA_SPARSE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_TAIGA_1);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, true);
    }

    public static void addAdventureSwamplandFeatures(BiomeGenerationSettings.Builder builder, boolean lilypads) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.EARLY_RELEASE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.TREES_SWAMP);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_SWAMP);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_TAIGA_1);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_DEAD_BUSH);
        if (lilypads) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_WATERLILY);
        }
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.BROWN_MUSHROOM_SWAMP);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.RED_MUSHROOM_SWAMP);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)builder);
    }

    public static void addIcePlainsFeatures(BiomeGenerationSettings.Builder builder, boolean grass) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.EARLY_RELEASE);
        if (grass) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        }
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_BETA_SPARSE);
        if (grass) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_TAIGA_1);
        }
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
    }

    public static void addOceanFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
        if (!pe) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.KELP_COLD);
        }
    }

    public static void addColdOceanFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
        if (!pe) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_COLD);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.KELP_COLD);
        }
    }

    public static void addFrozenOceanFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
    }

    public static void addLukewarmOceanFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
        if (!pe) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_WARM);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.KELP_WARM);
        }
    }

    public static void addWarmOceanFeatures(BiomeGenerationSettings.Builder builder, boolean pe) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, pe ? ModernBetaFeatureSettings.PE : ModernBetaFeatureSettings.BETA);
        if (pe) {
            ModernBetaBiomeFeatures.addPEVegetation(builder, false);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        }
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, false);
        if (!pe) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_WARM);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE);
        }
    }

    public static void addAlphaFeatures(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.ALPHA);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_CACTUS_ALPHA);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_ALPHA);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addDefaultVegetation(builder, true);
    }

    public static void addInfdev611Features(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INFDEV_611);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_INFDEV_611);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
    }

    public static void addInfdev420Features(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INFDEV_420);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_INFDEV_420);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
    }

    public static void addInfdev415Features(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INFDEV_415);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_INFDEV_415);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
    }

    public static void addInfdev325Features(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INFDEV_325);
        builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, ModernBetaOrePlacedFeatures.CAVE_INFDEV_325);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_INFDEV_227);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_INFDEV_325);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
    }

    public static void addInfdev227Features(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INFDEV_227);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_INFDEV_227);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
    }

    public static void addIndevHellFeatures(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INDEV);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_INDEV);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.MUSHROOM_HELL);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
    }

    public static void addIndevNormalFeatures(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INDEV);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_INDEV);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
    }

    public static void addIndevParadiseFeatures(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INDEV);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_FLOWER_PARADISE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_INDEV);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
    }

    public static void addIndevSnowyFeatures(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addIndevNormalFeatures(builder);
    }

    public static void addIndevWoodsFeatures(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INDEV);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION_2);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_INDEV_WOODS);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.MUSHROOM_HELL);
    }

    public static void addClassic14a08Features(BiomeGenerationSettings.Builder builder) {
        ModernBetaBiomeFeatures.addDefaultFeatures(builder, ModernBetaFeatureSettings.INDEV);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.TREES_CLASSIC_14A_08);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
    }

    public static void addDefaultFeatures(BiomeGenerationSettings.Builder builder, ModernBetaFeatureSettings featureSettings) {
        ModernBetaBiomeFeatures.addCarvers(builder, featureSettings.addCanyons, featureSettings.useBetaCarvers);
        if (featureSettings.addLakes) {
            ModernBetaBiomeFeatures.addLakes(builder);
        }
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addMineables(builder, featureSettings.addClay, featureSettings.addAlternateStones, featureSettings.addNewMineables);
        if (featureSettings.addSprings) {
            BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)builder);
        }
        if (featureSettings.useBetaFreezeTopLayer) {
            ModernBetaBiomeFeatures.addBetaFrozenTopLayer(builder);
        } else {
            BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)builder);
        }
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)builder);
        ModernBetaBiomeFeatures.addOres(builder);
    }

    public static void addDefaultFeatures(BiomeGenerationSettings.Builder builder, boolean isOcean, boolean addLakes, boolean addSprings) {
        if (addLakes) {
            ModernBetaBiomeFeatures.addLakes(builder);
        }
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)builder);
        if (addSprings) {
            BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)builder);
        }
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)builder);
    }

    private static void addCarvers(BiomeGenerationSettings.Builder builder, boolean addCanyons, boolean useBetaCarvers) {
        if (useBetaCarvers) {
            ModernBetaBiomeFeatures.addCarver(builder, ModernBetaConfiguredCarvers.BETA_CAVE);
            ModernBetaBiomeFeatures.addCarver(builder, ModernBetaConfiguredCarvers.BETA_CAVE_DEEP);
            if (addCanyons) {
                ModernBetaBiomeFeatures.addCarver(builder, ModernBetaConfiguredCarvers.BETA_CANYON);
            }
        } else {
            ModernBetaBiomeFeatures.addCarver(builder, Carvers.CAVE);
            ModernBetaBiomeFeatures.addCarver(builder, Carvers.CAVE_EXTRA_UNDERGROUND);
            if (addCanyons) {
                ModernBetaBiomeFeatures.addCarver(builder, Carvers.CANYON);
            }
        }
    }

    private static void addCarver(BiomeGenerationSettings.Builder builder, ResourceKey<ConfiguredWorldCarver<?>> carver) {
        builder.addCarver(carver);
    }

    private static void addLakes(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.LAKES, MiscOverworldPlacements.LAKE_LAVA_UNDERGROUND);
        builder.addFeature(GenerationStep.Decoration.LAKES, MiscOverworldPlacements.LAKE_LAVA_SURFACE);
    }

    private static void addMineables(BiomeGenerationSettings.Builder builder, boolean addClay, boolean addAlternateStones, boolean addNewMineables) {
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIRT);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GRAVEL);
        if (addClay) {
            builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModernBetaOrePlacedFeatures.ORE_CLAY);
        }
        if (addAlternateStones) {
            builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GRANITE_LOWER);
            builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIORITE_LOWER);
            builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_ANDESITE_LOWER);
        }
        if (addNewMineables) {
            builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_TUFF);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.GLOW_LICHEN);
        }
    }

    private static void addOres(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModernBetaOrePlacedFeatures.ORE_EMERALD_Y95);
    }

    private static void addBetaFrozenTopLayer(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModernBetaMiscPlacedFeatures.FREEZE_TOP_LAYER);
    }

    private static void addPEVegetation(BiomeGenerationSettings.Builder builder, boolean addGrass) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_DANDELION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_POPPY);
        if (addGrass) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModernBetaVegetationPlacedFeatures.PATCH_GRASS_ALPHA_2);
        }
    }

    private record ModernBetaFeatureSettings(boolean addCanyons, boolean addLakes, boolean addSprings, boolean addClay, boolean addAlternateStones, boolean addNewMineables, boolean useBetaFreezeTopLayer, boolean useBetaCarvers) {
        private static final ModernBetaFeatureSettings EARLY_RELEASE = new ModernBetaFeatureSettings(true, true, true, false, true, true, true, false);
        private static final ModernBetaFeatureSettings BETA = new ModernBetaFeatureSettings(true);
        private static final ModernBetaFeatureSettings PE = new ModernBetaFeatureSettings(true, false, true, true, false, true, true, true);
        private static final ModernBetaFeatureSettings SKY = new ModernBetaFeatureSettings(false, true, true, true, false, false, true, true);
        private static final ModernBetaFeatureSettings ALPHA = new ModernBetaFeatureSettings(false, false, true, true, false, false, false, true);
        private static final ModernBetaFeatureSettings INFDEV_611 = new ModernBetaFeatureSettings(false);
        private static final ModernBetaFeatureSettings INFDEV_420 = new ModernBetaFeatureSettings(false);
        private static final ModernBetaFeatureSettings INFDEV_415 = new ModernBetaFeatureSettings(false);
        private static final ModernBetaFeatureSettings INFDEV_325 = new ModernBetaFeatureSettings(false);
        private static final ModernBetaFeatureSettings INFDEV_227 = new ModernBetaFeatureSettings(false);
        private static final ModernBetaFeatureSettings INDEV = new ModernBetaFeatureSettings(false);

        private ModernBetaFeatureSettings(boolean setting) {
            this(setting, setting, setting, setting, setting, setting, setting, setting);
        }
    }
}

