/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.injector;

import java.util.Optional;
import java.util.function.Predicate;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.biome.injector.BiomeInjectionRules;
import mod.bluestaggo.modernerbeta.level.cavebiome.provider.CaveBiomeProviderNone;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.mixin.LevelChunkSectionAccessor;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.Heightmap;

public class BiomeInjector {
    public static final int OCEAN_START_DEPTH = 4;
    public static final int OCEAN_DEEP_START_DEPTH = 16;
    public static final int CAVE_START_DEPTH = 8;
    private final ModernBetaChunkGenerator modernBetaChunkGenerator;
    private final ModernBetaBiomeSource modernBetaBiomeSource;
    private final BiomeInjectionRules rulesPre;
    private final BiomeInjectionRules rulesPost;
    private final BiomeInjectionRules rulesAll;

    public BiomeInjector(ModernBetaChunkGenerator modernBetaChunkGenerator, ModernBetaBiomeSource modernBetaBiomeSource) {
        this.modernBetaChunkGenerator = modernBetaChunkGenerator;
        this.modernBetaBiomeSource = modernBetaBiomeSource;
        ModernBetaSettings settingsBiome = this.modernBetaBiomeSource.getBiomeSettings().mapPreset(modernBetaChunkGenerator.getPresetRegistry(), ModernBetaSettingsPreset::biomeSettings);
        boolean useOceanBiomes = settingsBiome.getOrDefault(SettingsComponentTypes.USE_OCEAN_BIOMES);
        Predicate<BiomeInjectionRules.BiomeInjectionContext> cavePredicate = context -> context.getY() >= context.worldMinY && context.getY() + 8 < context.minHeight;
        Predicate<BiomeInjectionRules.BiomeInjectionContext> oceanPredicate = context -> modernBetaBiomeSource.hasOceanBiomes() && this.atOceanDepth(context.topHeight, 4);
        Predicate<BiomeInjectionRules.BiomeInjectionContext> deepOceanPredicate = context -> modernBetaBiomeSource.hasOceanBiomes() && this.atOceanDepth(context.topHeight, 16);
        BiomeInjectionRules.Builder builderPre = new BiomeInjectionRules.Builder();
        BiomeInjectionRules.Builder builderPost = new BiomeInjectionRules.Builder();
        BiomeInjectionRules.Builder builderAll = new BiomeInjectionRules.Builder();
        if (!(this.modernBetaBiomeSource.getCaveBiomeProvider() instanceof CaveBiomeProviderNone)) {
            builderPost.add(cavePredicate, this.modernBetaBiomeSource::getCaveBiome);
        }
        if (useOceanBiomes) {
            builderPost.add(deepOceanPredicate, this.modernBetaBiomeSource::getDeepOceanBiome);
            builderPost.add(oceanPredicate, this.modernBetaBiomeSource::getOceanBiome);
        }
        builderAll.add(builderPre).add(builderPost);
        this.rulesPre = builderPre.build();
        this.rulesPost = builderPost.build();
        this.rulesAll = builderAll.build();
    }

    public void injectBiomes(ChunkAccess chunk, Climate.Sampler noiseSampler, BiomeInjectionStep step) {
        if (this.rulesAll.isEmpty()) {
            return;
        }
        ChunkPos chunkPos = chunk.getPos();
        int startBiomeX = chunkPos.getMinBlockX() >> 2;
        int startBiomeZ = chunkPos.getMinBlockZ() >> 2;
        LevelHeightAccessor view = chunk.getHeightAccessorForGeneration();
        for (int sectionY = view.getMinSectionY(); sectionY < view.getMaxSectionY(); ++sectionY) {
            int sectionYNdx = chunk.getSectionIndexFromSectionY(sectionY);
            LevelChunkSection section = chunk.getSection(sectionYNdx);
            PalettedContainerRO readableContainer = section.getBiomes();
            PalettedContainer palettedContainer = section.getBiomes().recreate();
            for (int localBiomeX = 0; localBiomeX < 4; ++localBiomeX) {
                for (int localBiomeZ = 0; localBiomeZ < 4; ++localBiomeZ) {
                    int biomeX = localBiomeX + startBiomeX;
                    int biomeZ = localBiomeZ + startBiomeZ;
                    for (int localBiomeY = 0; localBiomeY < 4; ++localBiomeY) {
                        int biomeY = localBiomeY + sectionY << 2;
                        Holder initialBiome = (Holder)readableContainer.get(localBiomeX, localBiomeY, localBiomeZ);
                        Holder<Biome> replacementBiome = this.getOptionalBiome(view, biomeX, biomeY, biomeZ, noiseSampler, step).orElse((Holder<Biome>)initialBiome);
                        palettedContainer.set(localBiomeX, localBiomeY, localBiomeZ, replacementBiome);
                    }
                }
            }
            ((LevelChunkSectionAccessor)section).setBiomes((PalettedContainerRO<Holder<Biome>>)palettedContainer);
        }
    }

    public Holder<Biome> getBiomeAtBlock(LevelHeightAccessor level, int x, int y, int z, Climate.Sampler noiseSampler, BiomeInjectionStep step) {
        int biomeX = x >> 2;
        int biomeY = y >> 2;
        int biomeZ = z >> 2;
        return this.getBiome(level, biomeX, biomeY, biomeZ, noiseSampler, step);
    }

    public String getBiomeNameAtBlock(LevelHeightAccessor level, int x, int y, int z, Climate.Sampler noiseSampler, BiomeInjectionStep step) {
        int biomeX = x >> 2;
        int biomeY = y >> 2;
        int biomeZ = z >> 2;
        ResourceKey key = this.getBiome(level, biomeX, biomeY, biomeZ, noiseSampler, step).unwrapKey().orElse(null);
        if (key == null) {
            return "???";
        }
        return key.location().toString();
    }

    public Holder<Biome> getBiome(LevelHeightAccessor level, int biomeX, int biomeY, int biomeZ, Climate.Sampler noiseSampler, BiomeInjectionStep step) {
        if (this.rulesAll.isEmpty()) {
            return this.modernBetaBiomeSource.getNoiseBiome(biomeX, biomeY, biomeZ, noiseSampler);
        }
        BiomeInjectionRules.BiomeInjectionContext context = this.createContext(level, biomeX, biomeY, biomeZ);
        return this.getBiome(context, biomeX, biomeY, biomeZ, noiseSampler, step).orElseGet(() -> this.modernBetaBiomeSource.getNoiseBiome(biomeX, biomeY, biomeZ, noiseSampler));
    }

    public Optional<Holder<Biome>> getOptionalBiome(LevelHeightAccessor level, int biomeX, int biomeY, int biomeZ, Climate.Sampler noiseSampler, BiomeInjectionStep step) {
        BiomeInjectionRules.BiomeInjectionContext context = this.createContext(level, biomeX, biomeY, biomeZ);
        return this.getBiome(context, biomeX, biomeY, biomeZ, noiseSampler, step);
    }

    private Optional<Holder<Biome>> getBiome(BiomeInjectionRules.BiomeInjectionContext context, int biomeX, int biomeY, int biomeZ, Climate.Sampler noiseSampler, BiomeInjectionStep step) {
        Holder<Biome> biome = switch (step.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.rulesPre.test(context, biomeX, biomeY, biomeZ);
            case 1 -> this.rulesPost.test(context, biomeX, biomeY, biomeZ);
            case 2 -> this.rulesAll.test(context, biomeX, biomeY, biomeZ);
        };
        return Optional.ofNullable(biome);
    }

    private BiomeInjectionRules.BiomeInjectionContext createContext(LevelHeightAccessor level, int biomeX, int biomeY, int biomeZ) {
        int y = biomeY << 2;
        int worldMinY = this.modernBetaChunkGenerator.getMinY();
        int topHeight = this.sampleTopHeight(level, biomeX, biomeZ);
        int minHeight = this.sampleMinHeight(level, biomeX, biomeZ);
        return new BiomeInjectionRules.BiomeInjectionContext(worldMinY, topHeight, minHeight).setY(y);
    }

    private int sampleTopHeight(LevelHeightAccessor level, int biomeX, int biomeZ) {
        int x = (biomeX << 2) + 2;
        int z = (biomeZ << 2) + 2;
        return this.modernBetaChunkGenerator.getHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, level);
    }

    private int sampleFloorHeight(LevelHeightAccessor level, int biomeX, int biomeZ) {
        int n;
        int x = (biomeX << 2) + 2;
        int z = (biomeZ << 2) + 2;
        ChunkProvider chunkProvider = this.modernBetaChunkGenerator.getChunkProvider();
        if (chunkProvider instanceof ChunkProviderNoise) {
            ChunkProviderNoise chunkProviderNoise = (ChunkProviderNoise)chunkProvider;
            n = chunkProviderNoise.getHeight(level, x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = chunkProvider.getHeight(level, x, z, Heightmap.Types.OCEAN_FLOOR_WG);
        }
        return n;
    }

    private int sampleMinHeight(LevelHeightAccessor level, int centerBiomeX, int centerBiomeZ) {
        int minHeight = Integer.MAX_VALUE;
        for (int localBiomeX = -1; localBiomeX <= 1; ++localBiomeX) {
            for (int localBiomeZ = -1; localBiomeZ <= 1; ++localBiomeZ) {
                int biomeX = centerBiomeX + localBiomeX;
                int biomeZ = centerBiomeZ + localBiomeZ;
                minHeight = Math.min(minHeight, this.sampleFloorHeight(level, biomeX, biomeZ));
            }
        }
        return minHeight;
    }

    private boolean atOceanDepth(int topHeight, int oceanDepth) {
        return topHeight < this.modernBetaChunkGenerator.getSeaLevel() - oceanDepth;
    }

    public static enum BiomeInjectionStep {
        PRE,
        POST,
        ALL;

    }
}

