/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.util.VersionCompat;

public class InitLandLayer
extends Layer {
    public static final MapCodec<InitLandLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> InitLandLayer.fillLayerFields(instance).and((App)Codec.INT.fieldOf("landChance").orElse((Object)10).forGetter(layer -> layer.landChance)).apply((Applicative)instance, InitLandLayer::new));
    public final int landChance;

    public InitLandLayer(String id, long seed) {
        this(id, seed, 10);
    }

    public InitLandLayer(String id, long seed, int landChance) {
        super(id, seed);
        this.landChance = landChance;
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.INIT_LAND;
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        if (x == 0 && z == 0 || this.getRandom(x, z).nextInt(this.landChance) == 0) {
            return ExtendedBiomeId.PLAINS;
        }
        return ExtendedBiomeId.OCEAN;
    }

    @Override
    protected void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
        biomes.add(ExtendedBiomeId.OCEAN);
        biomes.add(ExtendedBiomeId.PLAINS);
    }
}

