/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Set;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.util.VersionCompat;

public class RandomBiomeLayer
extends Layer {
    public static final MapCodec<RandomBiomeLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> RandomBiomeLayer.fillLayerFields(instance).and((App)ExtendedBiomeId.CODEC.listOf().fieldOf("biomes").forGetter(layer -> layer.biomes)).apply((Applicative)instance, RandomBiomeLayer::new));
    private final List<ExtendedBiomeId> biomes;

    public RandomBiomeLayer(String id, long seed, List<ExtendedBiomeId> biomes) {
        super(id, seed);
        this.biomes = biomes;
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.RANDOM_BIOME;
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        LayerRandom random = this.getRandom(x, z);
        return random.nextItem(this.biomes);
    }

    @Override
    protected void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
        biomes.addAll(this.biomes);
    }
}

