/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.FuzzyZoomLayer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.util.Mth;

public class VoronoiZoomLayer
extends FuzzyZoomLayer {
    public static final MapCodec<VoronoiZoomLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> VoronoiZoomLayer.fillSingleParentLayerFields(instance).and((App)Codec.INT.fieldOf("scale").orElse((Object)4).forGetter(layer -> layer.scale)).apply((Applicative)instance, VoronoiZoomLayer::new));
    private final int scale;

    public VoronoiZoomLayer(String id, long seed, String parent, int scale) {
        super(id, seed, parent);
        this.scale = scale;
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.VORONOI_ZOOM;
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        int voronoiZoom = this.scale;
        double voronoiFactor = (double)voronoiZoom * 0.9;
        int scaledX = Math.floorDiv(x, voronoiZoom);
        int scaledZ = Math.floorDiv(z, voronoiZoom);
        int subX = Math.floorMod(x, voronoiZoom);
        int subZ = Math.floorMod(z, voronoiZoom);
        LayerRandom voronoiRandom = this.getRandom(scaledX, scaledZ);
        double n00x = ((double)voronoiRandom.nextInt(1024) / 1024.0 - 0.5) * voronoiFactor;
        double n00z = ((double)voronoiRandom.nextInt(1024) / 1024.0 - 0.5) * voronoiFactor;
        voronoiRandom.init(scaledX + 1, scaledZ);
        double n10x = ((double)voronoiRandom.nextInt(1024) / 1024.0 - 0.5) * voronoiFactor + (double)voronoiZoom;
        double n10z = ((double)voronoiRandom.nextInt(1024) / 1024.0 - 0.5) * voronoiFactor;
        voronoiRandom.init(scaledX, scaledZ + 1);
        double n01x = ((double)voronoiRandom.nextInt(1024) / 1024.0 - 0.5) * voronoiFactor;
        double n01z = ((double)voronoiRandom.nextInt(1024) / 1024.0 - 0.5) * voronoiFactor + (double)voronoiZoom;
        voronoiRandom.init(scaledX + 1, scaledZ + 1);
        double n11x = ((double)voronoiRandom.nextInt(1024) / 1024.0 - 0.5) * voronoiFactor + (double)voronoiZoom;
        double n11z = ((double)voronoiRandom.nextInt(1024) / 1024.0 - 0.5) * voronoiFactor + (double)voronoiZoom;
        double dist00 = Mth.square((double)((double)subX - n00x)) + Mth.square((double)((double)subZ - n00z));
        double dist10 = Mth.square((double)((double)subX - n10x)) + Mth.square((double)((double)subZ - n10z));
        double dist01 = Mth.square((double)((double)subX - n01x)) + Mth.square((double)((double)subZ - n01z));
        double dist11 = Mth.square((double)((double)subX - n11x)) + Mth.square((double)((double)subZ - n11z));
        if (dist00 < dist10 && dist00 < dist01 && dist00 < dist11) {
            return this.parentLayer.sample(scaledX, scaledZ);
        }
        if (dist10 < dist00 && dist10 < dist01 && dist10 < dist11) {
            return this.parentLayer.sample(scaledX + 1, scaledZ);
        }
        if (dist01 < dist00 && dist01 < dist10 && dist01 < dist11) {
            return this.parentLayer.sample(scaledX, scaledZ + 1);
        }
        return this.parentLayer.sample(scaledX + 1, scaledZ + 1);
    }
}

