/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.AllOfBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.AnyOfBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.BiomePredicateType;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.CategorizedNeighborBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.IdenticalNeighborBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.InGridBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.InRangeBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.InSetBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.InvertedBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.NeighborMatchBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.RandomChanceBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.SingleMatchBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.TrueBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.UniqueNeighborBiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.WrappedIntMatchBiomePredicate;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;

public interface BiomePredicate {
    public static final Codec<BiomePredicate> BASE_CODEC = ModernBetaRegistries.BIOME_PREDICATE.byNameCodec().dispatch("condition", BiomePredicate::getType, BiomePredicateType::codec);

    public static BiomePredicate allOf(BiomePredicate ... predicates) {
        return new AllOfBiomePredicate(List.of(predicates));
    }

    public static BiomePredicate anyOf(BiomePredicate ... predicates) {
        return new AnyOfBiomePredicate(List.of(predicates));
    }

    public static BiomePredicate anyOf(List<BiomePredicate> predicates) {
        return new AnyOfBiomePredicate(predicates);
    }

    public static BiomePredicate border() {
        return new UniqueNeighborBiomePredicate(1, false);
    }

    public static BiomePredicate diagonalBorder() {
        return new UniqueNeighborBiomePredicate(1, true);
    }

    public static BiomePredicate diagonalInterior() {
        return new IdenticalNeighborBiomePredicate(4, true);
    }

    public static BiomePredicate diagonalNeighborsMatch(BiomePredicate predicate, int neighborCount) {
        return new NeighborMatchBiomePredicate(neighborCount, true, predicate);
    }

    public static BiomePredicate diagonalNeighborsMatch(ExtendedBiomeId biome, int neighborCount) {
        return BiomePredicate.diagonalNeighborsMatch(BiomePredicate.of(biome), neighborCount);
    }

    public static BiomePredicate diagonalNeighborsMatch(List<Set<ExtendedBiomeId>> categories, int neighborCount) {
        return new CategorizedNeighborBiomePredicate(neighborCount, true, categories);
    }

    public static BiomePredicate identicalNeighbors(int count, boolean diagonal) {
        return new IdenticalNeighborBiomePredicate(count, diagonal);
    }

    public static BiomePredicate inGrid(int size, int spacing, int offset) {
        return new InGridBiomePredicate(size, spacing, offset);
    }

    public static BiomePredicate inRange(int centerX, int centerZ, int width, int length, boolean evenSize, InRangeBiomePredicate.Shape shape) {
        return new InRangeBiomePredicate(centerX, centerZ, width, length, evenSize, shape);
    }

    public static BiomePredicate inSet(ExtendedBiomeId ... biomes) {
        return new InSetBiomePredicate(Set.of(biomes));
    }

    public static BiomePredicate inSet(Set<ExtendedBiomeId> biomes) {
        return new InSetBiomePredicate(biomes);
    }

    public static BiomePredicate interior() {
        return new IdenticalNeighborBiomePredicate(4, false);
    }

    public static BiomePredicate neighborsMatch(BiomePredicate predicate, int neighborCount) {
        return new NeighborMatchBiomePredicate(neighborCount, false, predicate);
    }

    public static BiomePredicate neighborsMatch(ExtendedBiomeId biome, int neighborCount) {
        return BiomePredicate.neighborsMatch(BiomePredicate.of(biome), neighborCount);
    }

    public static BiomePredicate neighborsMatch(List<Set<ExtendedBiomeId>> categories, int neighborCount) {
        return new CategorizedNeighborBiomePredicate(neighborCount, false, categories);
    }

    public static BiomePredicate noneOf(BiomePredicate ... predicates) {
        return BiomePredicate.anyOf(predicates).invert();
    }

    public static BiomePredicate noneOf(List<BiomePredicate> predicates) {
        return BiomePredicate.anyOf(predicates).invert();
    }

    public static BiomePredicate noneInSet(ExtendedBiomeId ... biomes) {
        return BiomePredicate.inSet(biomes).invert();
    }

    public static BiomePredicate noneInSet(Set<ExtendedBiomeId> biomes) {
        return BiomePredicate.inSet(biomes).invert();
    }

    public static BiomePredicate of(ExtendedBiomeId biome) {
        return new SingleMatchBiomePredicate(biome);
    }

    public static BiomePredicate ofTrue() {
        return TrueBiomePredicate.INSTANCE;
    }

    public static BiomePredicate oneIn(int chance) {
        return new RandomChanceBiomePredicate(1, chance);
    }

    public static BiomePredicate randomChance(int numerator, int denominator) {
        return new RandomChanceBiomePredicate(numerator, denominator);
    }

    public static BiomePredicate simpleHills(Set<ExtendedBiomeId> affectedBiomes) {
        return BiomePredicate.inSet(affectedBiomes).and(BiomePredicate.interior()).and(BiomePredicate.oneIn(3));
    }

    public static BiomePredicate uniqueNeighbors(int count, boolean diagonal) {
        return new UniqueNeighborBiomePredicate(count, diagonal);
    }

    public static BiomePredicate wrappedIntMatch(int range, int match) {
        return new WrappedIntMatchBiomePredicate(range, match);
    }

    default public BiomePredicate and(BiomePredicate other) {
        return new AllOfBiomePredicate(List.of(this, other));
    }

    default public BiomePredicate or(BiomePredicate other) {
        return new AnyOfBiomePredicate(List.of(this, other));
    }

    default public BiomePredicate invert() {
        return new InvertedBiomePredicate(this);
    }

    public BiomePredicateType<?> getType();

    public boolean matches(ExtendedBiomeId var1, Layer var2, Supplier<LayerRandom> var3, int var4, int var5);
}

