/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.BiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.BiomePredicateType;
import mod.bluestaggo.modernerbeta.util.VersionCompat;

public record WrappedIntMatchBiomePredicate(int range, int match) implements BiomePredicate
{
    public static final MapCodec<WrappedIntMatchBiomePredicate> CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)Codec.INT.fieldOf("range").forGetter(predicate -> predicate.range), (App)Codec.INT.fieldOf("match").orElse((Object)0).forGetter(predicate -> predicate.match)).apply((Applicative)instance, WrappedIntMatchBiomePredicate::new));

    @Override
    public BiomePredicateType<?> getType() {
        return BiomePredicateType.MUTATION;
    }

    @Override
    public boolean matches(ExtendedBiomeId biome, Layer layer, Supplier<LayerRandom> randomSupplier, int x, int z) {
        try {
            int random = Integer.parseInt(biome.ext());
            return random % this.range == this.match;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

