/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.blocksource;

import java.util.ArrayList;
import java.util.List;
import mod.bluestaggo.modernerbeta.api.level.blocksource.BlockSource;
import net.minecraft.world.level.block.state.BlockState;

public class BlockSourceRules
implements BlockSource {
    private static final boolean DEBUG = false;
    private final List<BlockSource> rules;
    private final BlockState defaultBlock;

    private BlockSourceRules(List<BlockSource> blockSources, BlockState defaultBlock) {
        this.rules = blockSources;
        this.defaultBlock = defaultBlock;
    }

    @Override
    public BlockState apply(int x, int y, int z) {
        for (BlockSource blockSource : this.rules) {
            BlockState blockState = blockSource.apply(x, y, z);
            if (blockState == null) continue;
            return blockState;
        }
        return this.defaultBlock;
    }

    public static class Builder {
        private final List<BlockSource> rules = new ArrayList<BlockSource>();

        public Builder add(BlockSource blockSource) {
            this.rules.add(blockSource);
            return this;
        }

        public BlockSourceRules build(BlockState defaultBlock) {
            return new BlockSourceRules(this.rules, defaultBlock);
        }
    }
}

