/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.carver.configured;

import java.util.Optional;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.level.carver.BetaCaveCarverConfiguration;
import mod.bluestaggo.modernerbeta.level.carver.ModernBetaCarvers;
import mod.bluestaggo.modernerbeta.tags.ModernBetaBlockTags;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.TrapezoidFloat;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.heightproviders.BiasedToBottomHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;

public class ModernBetaConfiguredCarvers {
    public static final ResourceKey<ConfiguredWorldCarver<?>> BETA_CAVE = ModernBetaConfiguredCarvers.of("beta_cave");
    public static final ResourceKey<ConfiguredWorldCarver<?>> BETA_CAVE_DEEP = ModernBetaConfiguredCarvers.of("beta_cave_deep");
    public static final ResourceKey<ConfiguredWorldCarver<?>> BETA_CANYON = ModernBetaConfiguredCarvers.of("beta_canyon");

    public static void bootstrap(BootstrapContext<?> context) {
        BootstrapContext<?> carverRegisterable = context;
        HolderGetter registryBlock = carverRegisterable.lookup(Registries.BLOCK);
        boolean useFixedCaves = false;
        boolean useAquifers = false;
        boolean useSurfaceRules = false;
        BetaCaveCarverConfiguration configCave = new BetaCaveCarverConfiguration(0.0f, (HeightProvider)BiasedToBottomHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)127), (int)8), (FloatProvider)ConstantFloat.of((float)0.5f), VerticalAnchor.aboveBottom((int)10), CarverDebugSettings.of((boolean)false, (BlockState)Blocks.WARPED_BUTTON.defaultBlockState()), (HolderSet<Block>)registryBlock.getOrThrow(ModernBetaBlockTags.OVERWORLD_CARVER_REPLACEABLES), (FloatProvider)ConstantFloat.of((float)1.0f), (FloatProvider)ConstantFloat.of((float)1.0f), (FloatProvider)ConstantFloat.of((float)-0.7f), Optional.of(useFixedCaves), Optional.of(useAquifers), Optional.of(useSurfaceRules));
        BetaCaveCarverConfiguration configCaveDeep = new BetaCaveCarverConfiguration(0.15f, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)0)), (FloatProvider)UniformFloat.of((float)0.1f, (float)0.9f), VerticalAnchor.aboveBottom((int)10), CarverDebugSettings.of((boolean)false, (BlockState)Blocks.CRIMSON_BUTTON.defaultBlockState()), (HolderSet<Block>)registryBlock.getOrThrow(ModernBetaBlockTags.OVERWORLD_CARVER_REPLACEABLES), (FloatProvider)UniformFloat.of((float)0.7f, (float)1.4f), (FloatProvider)UniformFloat.of((float)0.8f, (float)1.3f), (FloatProvider)UniformFloat.of((float)-1.0f, (float)-0.4f), Optional.of(useFixedCaves), Optional.of(useAquifers), Optional.of(useSurfaceRules));
        CanyonCarverConfiguration configRavine = new CanyonCarverConfiguration(0.02f, (HeightProvider)BiasedToBottomHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)20), (VerticalAnchor)VerticalAnchor.absolute((int)67), (int)8), (FloatProvider)ConstantFloat.of((float)3.0f), VerticalAnchor.aboveBottom((int)10), CarverDebugSettings.of((boolean)false, (BlockState)Blocks.WARPED_BUTTON.defaultBlockState()), (HolderSet)registryBlock.getOrThrow(BlockTags.OVERWORLD_CARVER_REPLACEABLES), (FloatProvider)UniformFloat.of((float)-0.125f, (float)0.125f), new CanyonCarverConfiguration.CanyonShapeConfiguration((FloatProvider)UniformFloat.of((float)0.75f, (float)1.0f), (FloatProvider)TrapezoidFloat.of((float)0.0f, (float)6.0f, (float)2.0f), 3, (FloatProvider)UniformFloat.of((float)0.75f, (float)1.0f), 1.0f, 0.0f));
        carverRegisterable.register(BETA_CAVE, (Object)ModernBetaCarvers.BETA_CAVE.configured((CarverConfiguration)configCave));
        carverRegisterable.register(BETA_CAVE_DEEP, (Object)WorldCarver.CAVE.configured((CarverConfiguration)configCaveDeep));
        carverRegisterable.register(BETA_CANYON, (Object)WorldCarver.CANYON.configured((CarverConfiguration)configRavine));
    }

    public static ResourceKey<ConfiguredWorldCarver<?>> of(String id) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_CARVER, (ResourceLocation)ModernerBeta.createId(id));
    }
}

