/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.chunk;

import java.util.List;
import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaNoiseSettings;
import mod.bluestaggo.modernerbeta.mixin.NoiseRouterDataAccessor;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class ModernBetaNoiseGeneratorSettings {
    private static boolean useModernBetaSurfaceRules;
    public static final ResourceKey<NoiseGeneratorSettings> INFDEV_415;
    public static final ResourceKey<NoiseGeneratorSettings> FINITE_2D;
    public static final ResourceKey<NoiseGeneratorSettings> SKY_128;
    public static final ResourceKey<NoiseGeneratorSettings> OVERWORLD_128;
    public static final ResourceKey<NoiseGeneratorSettings> OVERWORLD_256;

    public static void bootstrap(BootstrapContext<NoiseGeneratorSettings> context) {
        context.register(FINITE_2D, (Object)ModernBetaNoiseGeneratorSettings.createNoiseGeneratorSettings(context, ModernBetaNoiseSettings.FINITE_2D, 64, false));
        context.register(INFDEV_415, (Object)ModernBetaNoiseGeneratorSettings.createNoiseGeneratorSettings(context, ModernBetaNoiseSettings.INFDEV_415, 64, true));
        context.register(SKY_128, (Object)ModernBetaNoiseGeneratorSettings.createNoiseGeneratorSettings(context, ModernBetaNoiseSettings.SKY_128, 0, false));
        context.register(OVERWORLD_128, (Object)ModernBetaNoiseGeneratorSettings.createNoiseGeneratorSettings(context, ModernBetaNoiseSettings.OVERWORLD_128, 64, true));
        context.register(OVERWORLD_256, (Object)ModernBetaNoiseGeneratorSettings.createNoiseGeneratorSettings(context, ModernBetaNoiseSettings.OVERWORLD_256, 64, true));
    }

    private static NoiseRouter createDensityFunctions(HolderGetter<DensityFunction> densityFunctionLookup, HolderGetter<NormalNoise.NoiseParameters> noiseParametersLookup) {
        Holder.Reference aquiferBarrier = noiseParametersLookup.getOrThrow(Noises.AQUIFER_BARRIER);
        Holder.Reference aquiferFloodedness = noiseParametersLookup.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS);
        Holder.Reference aquiferSpread = noiseParametersLookup.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_SPREAD);
        Holder.Reference aquiferLava = noiseParametersLookup.getOrThrow(Noises.AQUIFER_LAVA);
        Holder.Reference caveEntranceNoise = noiseParametersLookup.getOrThrow(Noises.CAVE_ENTRANCE);
        DensityFunction functionAquiferBarrier = DensityFunctions.noise((Holder)aquiferBarrier, (double)0.5);
        DensityFunction functionAquiferFloodedness = DensityFunctions.noise((Holder)aquiferFloodedness, (double)0.67);
        DensityFunction functionAquiferSpread = DensityFunctions.noise((Holder)aquiferSpread, (double)0.7142857142857143);
        DensityFunction functionAquiferLava = DensityFunctions.noise((Holder)aquiferLava);
        DensityFunction functionCaveEntranceNoise = DensityFunctions.noise((Holder)caveEntranceNoise);
        DensityFunction functionSlopedCheeseEstimate = DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)0, (int)64, (double)3.0, (double)1.0), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-0.5), (DensityFunction)functionCaveEntranceNoise));
        DensityFunction functionCaveEntrances = DensityFunctions.min((DensityFunction)functionSlopedCheeseEstimate, (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)5.0), (DensityFunction)new DensityFunctions.HolderHolder((Holder)densityFunctionLookup.getOrThrow(NoiseRouterDataAccessor.getEntrancesKey()))));
        DensityFunction functionCaves = DensityFunctions.rangeChoice((DensityFunction)functionSlopedCheeseEstimate, (double)-1000000.0, (double)1.5625, (DensityFunction)functionCaveEntrances, (DensityFunction)NoiseRouterDataAccessor.invokeUnderground(densityFunctionLookup, noiseParametersLookup, functionSlopedCheeseEstimate));
        DensityFunction functionCavesWithNoodles = DensityFunctions.min((DensityFunction)NoiseRouterDataAccessor.invokePostProcess(NoiseRouterDataAccessor.invokeSlideOverworld(false, functionCaves)), (DensityFunction)new DensityFunctions.HolderHolder((Holder)densityFunctionLookup.getOrThrow(NoiseRouterDataAccessor.getNoodleKey())));
        return new NoiseRouter(functionAquiferBarrier, functionAquiferFloodedness, functionAquiferSpread, functionAquiferLava, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), functionCavesWithNoodles, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    private static NoiseGeneratorSettings createNoiseGeneratorSettings(BootstrapContext<NoiseGeneratorSettings> context, NoiseSettings shapeConfig, int seaLevel, boolean useAquifers) {
        HolderGetter densityFunctionLookup = context.lookup(Registries.DENSITY_FUNCTION);
        HolderGetter noiseParametersLookup = context.lookup(Registries.NOISE);
        return ModernBetaNoiseGeneratorSettings.createNoiseGeneratorSettings((HolderGetter<DensityFunction>)densityFunctionLookup, (HolderGetter<NormalNoise.NoiseParameters>)noiseParametersLookup, shapeConfig, seaLevel, useAquifers);
    }

    public static NoiseGeneratorSettings createNoiseGeneratorSettings(HolderLookup.Provider lookup, NoiseSettings shapeConfig, int seaLevel, boolean useAquifers) {
        HolderLookup.RegistryLookup densityFunctionLookup = lookup.lookupOrThrow(Registries.DENSITY_FUNCTION);
        HolderLookup.RegistryLookup noiseParametersLookup = lookup.lookupOrThrow(Registries.NOISE);
        return ModernBetaNoiseGeneratorSettings.createNoiseGeneratorSettings((HolderGetter<DensityFunction>)densityFunctionLookup, (HolderGetter<NormalNoise.NoiseParameters>)noiseParametersLookup, shapeConfig, seaLevel, useAquifers);
    }

    private static NoiseGeneratorSettings createNoiseGeneratorSettings(HolderGetter<DensityFunction> densityFunctionLookup, HolderGetter<NormalNoise.NoiseParameters> noiseParametersLookup, NoiseSettings shapeConfig, int seaLevel, boolean useAquifers) {
        useModernBetaSurfaceRules = true;
        SurfaceRules.RuleSource materialRule = SurfaceRuleData.overworld();
        useModernBetaSurfaceRules = false;
        return new NoiseGeneratorSettings(shapeConfig, BlockStates.STONE, BlockStates.WATER, ModernBetaNoiseGeneratorSettings.createDensityFunctions(densityFunctionLookup, noiseParametersLookup), materialRule, List.of(), seaLevel, false, useAquifers, false, true);
    }

    public static boolean useModernBetaSurfaceRules() {
        return useModernBetaSurfaceRules;
    }

    static {
        INFDEV_415 = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernerBeta.createId("infdev_415"));
        FINITE_2D = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.FINITE_2D.id);
        SKY_128 = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernerBeta.createId("sky_128"));
        OVERWORLD_128 = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernerBeta.createId("overworld_128"));
        OVERWORLD_256 = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernerBeta.createId("overworld_256"));
    }
}

