/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class CaveInfdev325Feature
extends Feature<OreConfiguration> {
    public CaveInfdev325Feature(Codec<OreConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<OreConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        OreConfiguration config = (OreConfiguration)context.config();
        RandomSource random = context.random();
        int baseX = pos.getX();
        int baseY = pos.getY();
        int baseZ = pos.getZ();
        int numberOfBlocks = config.size;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        if (level.isStateAtPosition(pos, state -> state.is(Blocks.WATER))) {
            return false;
        }
        float radius = random.nextFloat() * 3.141593f;
        double x0 = (float)(baseX + 8) + Mth.sin((float)radius) * (float)numberOfBlocks * 0.4375f;
        double x1 = (float)(baseX + 8) - Mth.sin((float)radius) * (float)numberOfBlocks * 0.4375f;
        double z0 = (float)(baseZ + 8) + Mth.cos((float)radius) * (float)numberOfBlocks * 0.4375f;
        double z1 = (float)(baseZ + 8) - Mth.cos((float)radius) * (float)numberOfBlocks * 0.4375f;
        double y0 = baseY + random.nextInt(8) + 2;
        double y1 = baseY + random.nextInt(8) + 2;
        double sizeMultiplier = random.nextDouble() * 4.0 + 2.0;
        double fuzz = random.nextDouble() * 0.6;
        try (BulkSectionAccess chunkSectionCache = new BulkSectionAccess((LevelAccessor)level);){
            for (int block = 0; block <= numberOfBlocks; ++block) {
                double d6 = x0 + (x1 - x0) * (double)block / (double)numberOfBlocks;
                double d7 = y0 + (y1 - y0) * (double)block / (double)numberOfBlocks;
                double d8 = z0 + (z1 - z0) * (double)block / (double)numberOfBlocks;
                double d9 = random.nextDouble() * (double)numberOfBlocks / 16.0;
                double d10 = ((double)Mth.sin((float)((float)block * 3.141593f / (float)numberOfBlocks)) * sizeMultiplier + 1.0) * d9 + 1.0;
                double d11 = ((double)Mth.sin((float)((float)block * 3.141593f / (float)numberOfBlocks)) * sizeMultiplier + 1.0) * d9 + 1.0;
                int minX = Mth.floor((double)(d6 - d10 / 2.0));
                int maxX = Mth.floor((double)(d6 + d10 / 2.0));
                int minY = Mth.floor((double)(d7 - d11 / 2.0));
                int maxY = Mth.floor((double)(d7 + d11 / 2.0));
                int minZ = Mth.floor((double)(d8 - d10 / 2.0));
                int maxZ = Mth.floor((double)(d8 + d10 / 2.0));
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            double dX = ((double)x + 0.5 - d6) / (d10 / 2.0);
                            double dY = ((double)y + 0.5 - d7) / (d11 / 2.0);
                            double dZ = ((double)z + 0.5 - d8) / (d10 / 2.0);
                            if (dX * dX + dY * dY + dZ * dZ >= random.nextDouble() * fuzz + (1.0 - fuzz)) continue;
                            LevelChunkSection chunkSection = chunkSectionCache.getSection((BlockPos)mutablePos.set(x, y, z));
                            if (level.isOutsideBuildHeight(y) || chunkSection == null) continue;
                            int localX = SectionPos.sectionRelative((int)x);
                            int localY = SectionPos.sectionRelative((int)y);
                            int localZ = SectionPos.sectionRelative((int)z);
                            BlockState state2 = chunkSection.getBlockState(localX, localY, localZ);
                            for (OreConfiguration.TargetBlockState target : config.targetStates) {
                                if (!OreFeature.canPlaceOre((BlockState)state2, arg_0 -> ((BulkSectionAccess)chunkSectionCache).getBlockState(arg_0), (RandomSource)random, (OreConfiguration)config, (OreConfiguration.TargetBlockState)target, (BlockPos.MutableBlockPos)mutablePos)) continue;
                                chunkSection.setBlockState(localX, localY, localZ, target.state, false);
                            }
                        }
                    }
                }
            }
        }
        return true;
    }
}

