/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.feature.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mod.bluestaggo.modernerbeta.level.feature.placement.ModernBetaPlacementTypes;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.jetbrains.annotations.NotNull;

public class Infdev325CavePlacementModifier
extends PlacementModifier {
    public static final MapCodec<Infdev325CavePlacementModifier> MODIFIER_CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min_section").forGetter(i -> i.minSection), (App)Codec.INT.fieldOf("max_section").forGetter(i -> i.maxSection)).apply((Applicative)instance, Infdev325CavePlacementModifier::of));
    private final int minSection;
    private final int maxSection;
    private PerlinOctaveNoise octaves;

    protected Infdev325CavePlacementModifier(int minSection, int maxSection) {
        this.minSection = minSection;
        this.maxSection = maxSection;
    }

    public static Infdev325CavePlacementModifier of(int minSection, int maxSection) {
        return new Infdev325CavePlacementModifier(minSection, maxSection);
    }

    public void setOctaves(PerlinOctaveNoise octaves) {
        this.octaves = octaves;
    }

    @NotNull
    public PlacementModifierType<?> type() {
        return ModernBetaPlacementTypes.INFDEV_325_CAVES;
    }

    @NotNull
    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        int x = pos.getX();
        int z = pos.getZ();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        double scale = 0.0625;
        for (int section = this.minSection; section <= this.maxSection; ++section) {
            int fsection = section;
            int count = (int)(this.octaves.sample((double)x * scale, (double)section * scale * 64.0, (double)z * scale) + (128.0 - (double)section * 16.0) / 64.0);
            positions.addAll(IntStream.range(0, count).mapToObj(i -> pos.atY(fsection * 16).offset(random.nextInt(16), random.nextInt(16), random.nextInt(16))).toList());
        }
        return positions.stream();
    }
}

