/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.structure;

import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.level.structure.ModernBetaStructures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class ModernBetaStructureSets {
    public static final ResourceKey<StructureSet> INDEV_STRONGHOLDS = ModernBetaStructureSets.keyOf("indev_strongholds");
    public static final ResourceKey<StructureSet> OCEAN_SHRINE = ModernBetaStructureSets.keyOf("ocean_shrine");

    public static void bootstrap(BootstrapContext<StructureSet> context) {
        HolderGetter registryStructure = context.lookup(Registries.STRUCTURE);
        HolderGetter registryBiome = context.lookup(Registries.BIOME);
        context.register(INDEV_STRONGHOLDS, (Object)new StructureSet((Holder)registryStructure.getOrThrow(ModernBetaStructures.INDEV_STRONGHOLD), (StructurePlacement)new ConcentricRingsStructurePlacement(0, 0, 1, (HolderSet)registryBiome.getOrThrow(BiomeTags.STRONGHOLD_BIASED_TO))));
        context.register(OCEAN_SHRINE, (Object)new StructureSet((Holder)registryStructure.getOrThrow(ModernBetaStructures.OCEAN_SHRINE), (StructurePlacement)new RandomSpreadStructurePlacement(64, 16, RandomSpreadType.TRIANGULAR, 357)));
    }

    private static ResourceKey<StructureSet> keyOf(String id) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ModernerBeta.createId(id));
    }
}

