/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.structure;

import java.util.Map;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.level.structure.OceanShrineStructure;
import mod.bluestaggo.modernerbeta.tags.ModernBetaBiomeTags;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdStructure;

public class ModernBetaStructures {
    public static final ResourceKey<Structure> INDEV_STRONGHOLD = ModernBetaStructures.of("indev_stronghold");
    public static final ResourceKey<Structure> OCEAN_SHRINE = ModernBetaStructures.of("ocean_shrine");

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter registryBiome = context.lookup(Registries.BIOME);
        context.register(INDEV_STRONGHOLD, (Object)new StrongholdStructure(ModernBetaStructures.createConfig((HolderSet<Biome>)registryBiome.getOrThrow(ModernBetaBiomeTags.INDEV_STRONGHOLD_HAS_STRUCTURE), TerrainAdjustment.BURY)));
        context.register(OCEAN_SHRINE, (Object)new OceanShrineStructure(ModernBetaStructures.createConfig((HolderSet<Biome>)registryBiome.getOrThrow(ModernBetaBiomeTags.OCEAN_SHRINE_HAS_STRUCTURE), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.GUARDIAN, 1, 2))), MobCategory.UNDERGROUND_WATER_CREATURE, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, MobSpawnSettings.EMPTY_MOB_LIST), MobCategory.AXOLOTLS, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, MobSpawnSettings.EMPTY_MOB_LIST)), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN)));
    }

    private static Structure.StructureSettings createConfig(HolderSet<Biome> biomes, TerrainAdjustment terrainAdaptation) {
        return ModernBetaStructures.createConfig(biomes, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, terrainAdaptation);
    }

    private static Structure.StructureSettings createConfig(HolderSet<Biome> biomes, Map<MobCategory, StructureSpawnOverride> spawns, GenerationStep.Decoration featureStep, TerrainAdjustment terrainAdaptation) {
        return new Structure.StructureSettings(biomes, spawns, featureStep, terrainAdaptation);
    }

    private static ResourceKey<Structure> of(String id) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ModernerBeta.createId(id));
    }
}

