/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.longs.Long2DoubleLinkedOpenHashMap;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.TemperatureHeightScaling;
import mod.bluestaggo.modernerbeta.imixin.ModernBetaLevel;
import mod.bluestaggo.modernerbeta.mixin.BiomeAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Level.class})
public abstract class MixinLevel
implements ModernBetaLevel {
    @Unique
    private static final int MODERNER_BETA$TEMPERATURE_CACHE_CAPACITY = 128;
    @Unique
    private boolean modernerBeta$isModded;
    @Unique
    private ClimateSampler modernerBeta$climateSampler;
    @Unique
    private TemperatureHeightScaling modernerBeta$temperatureHeightScaling;
    @Unique
    private final ThreadLocal<Long2DoubleLinkedOpenHashMap> modernerBeta$temperatureCache = ThreadLocal.withInitial(() -> {
        Long2DoubleLinkedOpenHashMap map = new Long2DoubleLinkedOpenHashMap(128);
        map.defaultReturnValue(Double.NaN);
        return map;
    });

    @Override
    public boolean modernerBeta$isModded() {
        return this.modernerBeta$isModded;
    }

    @Override
    public void modernerBeta$setModded(boolean toggle) {
        this.modernerBeta$isModded = toggle;
    }

    @Override
    public ClimateSampler modernerBeta$getClimateSampler() {
        return this.modernerBeta$climateSampler;
    }

    @Override
    public void modernerBeta$setClimateSampler(ClimateSampler climateSampler) {
        this.modernerBeta$climateSampler = climateSampler;
    }

    @Override
    public TemperatureHeightScaling modernerBeta$getTemperatureHeightScaling() {
        return this.modernerBeta$temperatureHeightScaling;
    }

    @Override
    public void modernerBeta$setTemperatureHeightScaling(TemperatureHeightScaling temperatureHeightScaling) {
        this.modernerBeta$temperatureHeightScaling = temperatureHeightScaling;
    }

    @Override
    public double modernerBeta$sampleTemperature(Biome biome, BlockPos pos) {
        long coord;
        Long2DoubleLinkedOpenHashMap temperatureCache = this.modernerBeta$temperatureCache.get();
        double temperature = temperatureCache.get(coord = pos.asLong());
        if (!Double.isNaN(temperature)) {
            return temperature;
        }
        temperature = this.modernerBeta$generateTemperature(biome, pos);
        if (temperatureCache.size() == 128) {
            temperatureCache.removeFirstDouble();
        }
        temperatureCache.put(coord, temperature);
        return temperature;
    }

    @Unique
    private double modernerBeta$generateTemperature(Biome biome, BlockPos pos) {
        Biome.TemperatureModifier temperatureModifier;
        BiomeAccessor biomeAccessor = (BiomeAccessor)biome;
        assert (biomeAccessor != null);
        ClimateSampler climateSampler = this.modernerBeta$getClimateSampler();
        TemperatureHeightScaling temperatureHeightScaling = this.modernerBeta$getTemperatureHeightScaling();
        if (climateSampler == null && temperatureHeightScaling == null) {
            return biomeAccessor.invokeGetTemperature(pos, 64);
        }
        double temperature = biome.getBaseTemperature();
        if (climateSampler != null) {
            temperature = climateSampler.sample(pos.getX(), pos.getZ()).temp();
        }
        if (temperatureHeightScaling.supportsModifier(temperatureModifier = biomeAccessor.getClimateSettings().temperatureModifier())) {
            temperature = temperatureModifier.modifyTemperature(pos, (float)temperature);
        }
        if (temperatureHeightScaling != null) {
            temperature = temperatureHeightScaling.modifyTemperature(pos, temperature);
        }
        return temperature;
    }

    @Override
    public Biome.Precipitation modernerBeta$samplePrecipitation(Biome biome, BlockPos pos) {
        if (!biome.hasPrecipitation()) {
            return Biome.Precipitation.NONE;
        }
        if (this.modernerBeta$getTemperatureHeightScaling() == TemperatureHeightScaling.BETA) {
            pos = pos.atY(64);
        }
        double temp = this.modernerBeta$sampleTemperature(biome, pos);
        double snowThreshold = this.modernerBeta$getClimateSampler() != null ? this.modernerBeta$getClimateSampler().getSnowThreshold() : 0.15;
        return temp < snowThreshold ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    @WrapOperation(method={"isRainingAt(Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getPrecipitationAt(Lnet/minecraft/core/BlockPos;I)Lnet/minecraft/world/level/biome/Biome$Precipitation;")})
    public Biome.Precipitation modifyTickPrecipitation(Biome biome, BlockPos blockPos, int seaLevel, Operation<Biome.Precipitation> original) {
        if (!this.modernerBeta$isModded()) {
            return (Biome.Precipitation)original.call(new Object[]{biome, blockPos, seaLevel});
        }
        return this.modernerBeta$samplePrecipitation(biome, blockPos);
    }
}

