/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin;

import mod.bluestaggo.modernerbeta.api.level.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.level.chunk.provider.ChunkProviderNoise3D;
import mod.bluestaggo.modernerbeta.level.feature.BetaSnowAndFreezeFeature;
import mod.bluestaggo.modernerbeta.level.feature.placed.ModernBetaMiscPlacedFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.SnowAndFreezeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SnowAndFreezeFeature.class})
public abstract class SnowAndFreezeFeatureMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectPlace(FeaturePlaceContext<NoneFeatureConfiguration> context, CallbackInfoReturnable<Boolean> info) {
        ModernBetaBiomeSource modernBetaBiomeSource;
        boolean hasClimateSampler;
        ModernBetaChunkGenerator modernBetaChunkGenerator;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        BiomeSource biomeSource = chunkGenerator.getBiomeSource();
        if (chunkGenerator instanceof ModernBetaChunkGenerator && (modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator).getChunkProvider() instanceof ChunkProviderNoise3D) {
            BetaSnowAndFreezeFeature.setFreezeTopLayer(level, pos, biomeSource, modernBetaChunkGenerator.allowSurfaceRules());
            info.setReturnValue((Object)true);
            return;
        }
        boolean bl = hasClimateSampler = biomeSource instanceof ModernBetaBiomeSource && (modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource).getBiomeProvider() instanceof ClimateSampler;
        if (hasClimateSampler) {
            int x = pos.getX();
            int z = pos.getZ();
            int y = context.level().getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
            BlockPos topPos = new BlockPos(x, y, z);
            Holder topBiome = context.level().getBiome(topPos);
            Holder.Reference betaFreezeTopLayer = context.level().registryAccess().lookupOrThrow(Registries.PLACED_FEATURE).get(ModernBetaMiscPlacedFeatures.FREEZE_TOP_LAYER).orElse(null);
            boolean hasBetaFreezeTopLayer = ((Biome)topBiome.value()).getGenerationSettings().features().stream().anyMatch(list -> list.contains((Holder)betaFreezeTopLayer));
            if (hasBetaFreezeTopLayer) {
                BetaSnowAndFreezeFeature.setFreezeTopLayer(level, pos, biomeSource, false);
                info.setReturnValue((Object)true);
            }
        }
    }
}

