/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin.server;

import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import mod.bluestaggo.modernerbeta.api.level.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.level.preset.ModernBetaWorldPresets;
import mod.bluestaggo.modernerbeta.registry.ModernBetaResourceKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/server/dedicated/DedicatedServerProperties$WorldDimensionData"})
public abstract class WorldDimensionDataMixin {
    @Unique
    private static final Logger modernBeta$LOGGER = LoggerFactory.getLogger((String)DedicatedServerProperties.class.getName());

    @Shadow
    public abstract JsonObject generatorSettings();

    @Inject(method={"create(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/level/levelgen/WorldDimensions;"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectCustomSettings(HolderLookup.Provider registries, CallbackInfoReturnable<WorldDimensions> cir, @Local Holder<WorldPreset> presetHolder, @Local WorldDimensions worldDimensions) {
        if (presetHolder.is(ModernBetaWorldPresets.MODERN_BETA)) {
            RegistryOps registryOps = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registries);
            Optional optional = ModernBetaSettingsPreset.SETTINGS_TEXT_CODEC.parse(new Dynamic((DynamicOps)registryOps, (Object)this.generatorSettings())).resultOrPartial(arg_0 -> ((Logger)modernBeta$LOGGER).error(arg_0));
            optional.ifPresent(settingsPreset -> {
                HolderLookup.RegistryLookup presetRegistry = registries.lookupOrThrow(ModernBetaResourceKeys.SETTINGS_PRESET);
                cir.setReturnValue((Object)worldDimensions.replaceOverworldGenerator(registries, (ChunkGenerator)new ModernBetaChunkGenerator(new ModernBetaBiomeSource((HolderGetter<Biome>)registries.lookupOrThrow(Registries.BIOME), (HolderGetter<ModernBetaSettingsPreset>)presetRegistry, settingsPreset.biomeSettings(), settingsPreset.caveBiomeSettings()), (HolderGetter<ModernBetaSettingsPreset>)presetRegistry, (HolderGetter<SurfaceConfig>)registries.lookupOrThrow(ModernBetaResourceKeys.SURFACE_CONFIG), settingsPreset.chunkSettings())));
            });
        }
    }
}

