/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.registry;

import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.api.level.BlockSourceCreator;
import mod.bluestaggo.modernerbeta.api.level.provider.BiomeProviderType;
import mod.bluestaggo.modernerbeta.api.level.provider.CaveBiomeProviderType;
import mod.bluestaggo.modernerbeta.api.level.provider.ChunkProviderType;
import mod.bluestaggo.modernerbeta.level.biome.HeightConfig;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.BiomePredicateType;
import mod.bluestaggo.modernerbeta.registry.IRegistryHelper;
import mod.bluestaggo.modernerbeta.registry.ModernBetaResourceKeys;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class ModernBetaRegistries {
    private static IRegistryHelper registryHelper;
    public static Registry<SettingsComponentType<?>> SETTINGS_COMPONENT_TYPE;
    public static Registry<ChunkProviderType<?>> CHUNK;
    public static Registry<BiomeProviderType<?>> BIOME;
    public static Registry<CaveBiomeProviderType<?>> CAVE_BIOME;
    public static Registry<HeightConfig> HEIGHT_CONFIG;
    public static Registry<BlockSourceCreator> BLOCKSOURCE;
    public static Registry<LayerType<?>> FRACTAL_LAYER;
    public static Registry<BiomePredicateType<?>> BIOME_PREDICATE;

    private static <T> Registry<T> register(ResourceKey<Registry<T>> key) {
        return registryHelper.createSimple(key).build();
    }

    private static <T> Registry<T> registerDefaulted(ResourceKey<Registry<T>> key, ResourceLocation defaultKey) {
        return registryHelper.createDefaulted(key, defaultKey).build();
    }

    public static void makeRegistries(IRegistryHelper helper) {
        registryHelper = helper;
        SETTINGS_COMPONENT_TYPE = ModernBetaRegistries.register(ModernBetaResourceKeys.SETTINGS_COMPONENT_TYPE);
        CHUNK = ModernBetaRegistries.registerDefaulted(ModernBetaResourceKeys.CHUNK, ModernBetaBuiltInTypes.Chunk.NOISE_3D.id);
        BIOME = ModernBetaRegistries.registerDefaulted(ModernBetaResourceKeys.BIOME, ModernBetaBuiltInTypes.Biome.BETA.id);
        CAVE_BIOME = ModernBetaRegistries.registerDefaulted(ModernBetaResourceKeys.CAVE_BIOME, ModernBetaBuiltInTypes.CaveBiome.NONE.id);
        HEIGHT_CONFIG = ModernBetaRegistries.registerDefaulted(ModernBetaResourceKeys.HEIGHT_CONFIG, ModernBetaBuiltInTypes.HeightConfig.HEIGHT_CONFIG_DEFAULT.id);
        BLOCKSOURCE = ModernBetaRegistries.register(ModernBetaResourceKeys.BLOCKSOURCE);
        FRACTAL_LAYER = ModernBetaRegistries.register(ModernBetaResourceKeys.FRACTAL_LAYER);
        BIOME_PREDICATE = ModernBetaRegistries.register(ModernBetaResourceKeys.BIOME_PREDICATE);
    }
}

