/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mod.bluestaggo.modernerbeta.registry.ModernBetaResourceKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.NameAndDescriptionItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public record ModernBetaSettingsPresetCategory(ResourceLocation defaultIcon, Optional<Component> categoryName, Optional<Component> categoryDescription, TagKey<ModernBetaSettingsPreset> presetTag) implements NameAndDescriptionItem
{
    public static final Codec<ModernBetaSettingsPresetCategory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("defaultIcon").forGetter(ModernBetaSettingsPresetCategory::defaultIcon), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(ModernBetaSettingsPresetCategory::categoryName), (App)ComponentSerialization.CODEC.optionalFieldOf("description").forGetter(ModernBetaSettingsPresetCategory::categoryDescription), (App)TagKey.codec(ModernBetaResourceKeys.SETTINGS_PRESET).fieldOf("presetTag").forGetter(ModernBetaSettingsPresetCategory::presetTag)).apply((Applicative)instance, ModernBetaSettingsPresetCategory::new));

    public ModernBetaSettingsPresetCategory(ResourceLocation defaultIcon, TagKey<ModernBetaSettingsPreset> presetTag) {
        this(defaultIcon, Optional.empty(), Optional.empty(), presetTag);
    }

    public ModernBetaSettingsPresetCategory(ResourceLocation defaultIcon, ResourceLocation id, TagKey<ModernBetaSettingsPreset> presetTag) {
        this(defaultIcon, Optional.of(ModernBetaSettingsPresetCategory.makeTitleComponent(id)), Optional.of(ModernBetaSettingsPresetCategory.makeDescriptionComponent(id)), presetTag);
    }

    @Override
    public Component makeOrGetTitleComponent(ResourceLocation fallbackId) {
        return this.categoryName.orElseGet(() -> ModernBetaSettingsPresetCategory.makeTitleComponent(fallbackId));
    }

    @Override
    public Component makeOrGetDescriptionComponent(ResourceLocation fallbackId) {
        return this.categoryDescription.orElseGet(() -> ModernBetaSettingsPresetCategory.makeDescriptionComponent(fallbackId));
    }

    @Override
    public ResourceLocation getTextureLocation(ResourceLocation fallbackId) {
        return NameAndDescriptionItem.super.getTextureLocation(this.defaultIcon);
    }

    private static Component makeTitleComponent(ResourceLocation id) {
        return Component.translatable((String)("createWorld.customize.modern_beta.preset_category.name." + id.toLanguageKey())).withStyle(ChatFormatting.AQUA);
    }

    private static Component makeDescriptionComponent(ResourceLocation id) {
        return Component.translatable((String)("createWorld.customize.modern_beta.preset_category.desc." + id.toLanguageKey()));
    }
}

