/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.settings.component.validation;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public interface ValidationResult<T> {
    public Type getResultType();

    @NotNull
    public Optional<T> result();

    default public T resultOrThrow() {
        return this.result().orElseThrow();
    }

    public boolean hasMessage();

    public Component message();

    public record Partial<T>(Component message, T resultValue) implements ValidationResult<T>
    {
        @Override
        public Type getResultType() {
            return Type.PARTIAL;
        }

        @Override
        @NotNull
        public Optional<T> result() {
            return Optional.ofNullable(this.resultValue);
        }

        @Override
        public boolean hasMessage() {
            return false;
        }
    }

    public record Invalid<T>(Component message) implements ValidationResult<T>
    {
        @Override
        public Type getResultType() {
            return Type.INVALID;
        }

        @Override
        @NotNull
        public Optional<T> result() {
            return Optional.empty();
        }

        @Override
        public boolean hasMessage() {
            return this.message != null;
        }
    }

    public record Valid<T>(T resultValue) implements ValidationResult<T>
    {
        @Override
        public Type getResultType() {
            return Type.VALID;
        }

        @Override
        @NotNull
        public Optional<T> result() {
            return Optional.ofNullable(this.resultValue);
        }

        @Override
        public boolean hasMessage() {
            return false;
        }

        @Override
        public Component message() {
            return null;
        }
    }

    public static enum Type {
        VALID,
        PARTIAL,
        INVALID;

    }
}

