/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.chunk;

import java.util.Arrays;
import net.minecraft.world.level.levelgen.Heightmap;

public class ChunkHeightmap {
    private final short[] heightmapSurface;
    private final short[] heightmapOcean;
    private final short[] heightmapSurfaceFloor;

    public ChunkHeightmap(short[] heightmapSurface, short[] heightmapOcean, short[] heightmapSurfaceFloor) {
        if (heightmapSurface.length != 256 || heightmapOcean.length != 256) {
            throw new IllegalArgumentException("[Modern Beta] Heightmap is an invalid size!");
        }
        this.heightmapSurface = heightmapSurface;
        this.heightmapOcean = heightmapOcean;
        this.heightmapSurfaceFloor = heightmapSurfaceFloor;
    }

    public ChunkHeightmap(int minHeight) {
        this.heightmapSurface = new short[256];
        this.heightmapOcean = new short[256];
        this.heightmapSurfaceFloor = new short[256];
        Arrays.fill(this.heightmapSurface, (short)minHeight);
        Arrays.fill(this.heightmapOcean, (short)minHeight);
        Arrays.fill(this.heightmapSurfaceFloor, (short)0);
    }

    public int getHeight(int x, int z, Heightmap.Types type) {
        int ndx = (z & 0xF) + (x & 0xF) * 16;
        return switch (type) {
            case Heightmap.Types.MOTION_BLOCKING -> this.heightmapOcean[ndx];
            case Heightmap.Types.MOTION_BLOCKING_NO_LEAVES -> this.heightmapOcean[ndx];
            case Heightmap.Types.OCEAN_FLOOR -> this.heightmapSurface[ndx];
            case Heightmap.Types.OCEAN_FLOOR_WG -> this.heightmapSurface[ndx];
            case Heightmap.Types.WORLD_SURFACE -> this.heightmapOcean[ndx];
            case Heightmap.Types.WORLD_SURFACE_WG -> this.heightmapOcean[ndx];
            default -> this.heightmapSurface[ndx];
        };
    }

    public int getHeight(int x, int z, Type type) {
        int ndx = (z & 0xF) + (x & 0xF) * 16;
        return switch (type.ordinal()) {
            case 1 -> this.heightmapSurface[ndx];
            case 2 -> this.heightmapOcean[ndx];
            case 0 -> this.heightmapSurfaceFloor[ndx];
            default -> this.heightmapSurface[ndx];
        };
    }

    public static enum Type {
        SURFACE_FLOOR,
        SURFACE,
        OCEAN;

    }
}

