/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core;

import dev.apexstudios.apexcore.core.seat.SeatSetup;
import dev.apexstudios.apexcore.core.util.TooltipMutationHandler;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentHelper;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponentTypes;
import dev.apexstudios.apexcore.lib.placement.PlacementRenderEvent;
import dev.apexstudios.apexcore.lib.registree.Registree;
import dev.apexstudios.apexcore.lib.util.ApexPackSources;
import dev.apexstudios.apexcore.lib.util.ApexTags;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@Mod(value="apexcore")
public final class ApexCore {
    public static final String ID = "apexcore";
    public static final Registree REGISTREE = new Registree("apexcore");

    public ApexCore(IEventBus modBus) {
        REGISTREE.registerEvents(modBus);
        ApexTags.register();
        BlockComponentTypes.register();
        BlockEntityComponentTypes.register();
        TooltipMutationHandler.register(modBus);
        SeatSetup.register(modBus);
        modBus.addListener(AddPackFindersEvent.class, event -> event.addPackFinders(ApexCore.identifier("packs/visual_vanilla"), PackType.SERVER_DATA, (Component)Component.literal((String)"Visual Vanilla"), ApexPackSources.BUILT_IN_NOT_AUTO, false, Pack.Position.TOP));
        NeoForge.EVENT_BUS.addListener(PlacementRenderEvent.DefaultBlockState.class, event -> {
            BlockState blockState = event.defaultBlockState();
            AtomicReference<BlockState> newBlockState = new AtomicReference<BlockState>(blockState);
            ComponentHolder<BlockComponent, Block> holder = BlockComponentHelper.asHolder(blockState);
            if (holder != null) {
                BlockPlaceContext context = event.placeContext();
                holder.runForComponent(BlockComponentTypes.FACING, component -> newBlockState.getAndUpdate(state -> component.setFor(context, (BlockState)state)));
                holder.runForComponent(BlockComponentTypes.ROTATION, component -> newBlockState.getAndUpdate(state -> component.setFor(context, (BlockState)state)));
                holder.runForComponent(BlockComponentTypes.FLUID_LOGGED, component -> newBlockState.getAndUpdate(state -> component.setFor(context, (BlockState)state)));
            }
            event.setDefaultBlockState(newBlockState.get());
        });
        NeoForge.EVENT_BUS.addListener(PlacementRenderEvent.ModifyBlockState.class, event -> {
            ItemStack stack;
            CustomData customData;
            BlockState blockState = event.originalBlockState();
            if (blockState.is(Blocks.LECTERN) && (customData = (CustomData)(stack = event.placeContext().getItemInHand()).getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).contains("Book")) {
                event.withProperty(LecternBlock.HAS_BOOK, () -> true);
            }
        });
    }

    public static ResourceLocation identifier(String identifier) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)identifier);
    }

    public static String id(String identifier) {
        return "apexcore:" + identifier;
    }
}

