/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data.provider.tag;

import com.google.common.collect.Lists;
import dev.apexstudios.apexcore.core.data.provider.tag.IntrusiveTagBuilderImpl;
import dev.apexstudios.apexcore.core.data.provider.tag.SimpleTagBuilderImpl;
import dev.apexstudios.apexcore.lib.data.provider.tag.TagBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;

sealed class TagBuilderImpl<TRegistry, TSelf extends TagBuilder<TRegistry, TSelf>>
implements TagBuilder<TRegistry, TSelf>
permits SimpleTagBuilderImpl, IntrusiveTagBuilderImpl {
    private final List<TagEntry> elements = Lists.newArrayList();
    private final List<TagEntry> removals = Lists.newArrayList();
    private final String namespace;
    private boolean replace = false;

    protected TagBuilderImpl(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public TSelf replace() {
        this.replace = true;
        return (TSelf)this;
    }

    @Override
    public TSelf withElement(ResourceLocation registryName) {
        this.elements.add(TagEntry.element((ResourceLocation)registryName));
        return (TSelf)this;
    }

    @Override
    public TSelf withElement(String identifier) {
        return this.withElement(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)identifier));
    }

    @Override
    public TSelf withOptionalElement(ResourceLocation registryName) {
        this.elements.add(TagEntry.optionalElement((ResourceLocation)registryName));
        return (TSelf)this;
    }

    @Override
    public TSelf withOptionalElement(String identifier) {
        return this.withOptionalElement(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)identifier));
    }

    @Override
    public TSelf withTag(ResourceLocation tagName) {
        this.elements.add(TagEntry.tag((ResourceLocation)tagName));
        return (TSelf)this;
    }

    @Override
    public TSelf withOptionalTag(ResourceLocation tagName) {
        this.elements.add(TagEntry.optionalTag((ResourceLocation)tagName));
        return (TSelf)this;
    }

    @Override
    public TSelf removeElement(ResourceLocation registryName) {
        this.removals.add(TagEntry.element((ResourceLocation)registryName));
        return (TSelf)this;
    }

    @Override
    public TSelf removeElement(String identifier) {
        return this.removeElement(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)identifier));
    }

    @Override
    public TSelf removeOptionalElement(ResourceLocation registryName) {
        this.removals.add(TagEntry.optionalElement((ResourceLocation)registryName));
        return (TSelf)this;
    }

    @Override
    public TSelf removeOptionalElement(String identifier) {
        return this.removeOptionalElement(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)identifier));
    }

    @Override
    public TSelf removeTag(ResourceLocation tagName) {
        this.removals.add(TagEntry.tag((ResourceLocation)tagName));
        return (TSelf)this;
    }

    @Override
    public TSelf removeOptionalTag(ResourceLocation tagName) {
        this.removals.add(TagEntry.optionalTag((ResourceLocation)tagName));
        return (TSelf)this;
    }

    TagFile compile() {
        return new TagFile(TagBuilderImpl.copyAndSort(this.elements), this.replace, TagBuilderImpl.copyAndSort(this.removals));
    }

    private static List<TagEntry> copyAndSort(List<TagEntry> list) {
        ArrayList copy = Lists.newArrayList(list);
        copy.sort(Comparator.comparing(TagEntry::isRequired).thenComparing(TagEntry::getId).thenComparing(TagEntry::isTag));
        return Collections.unmodifiableList(copy);
    }
}

