/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.placement;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.apexstudios.apexcore.lib.placement.BlockPlacementRenderer;
import dev.apexstudios.apexcore.lib.util.ApexTags;
import dev.apexstudios.apexcore.mixin.BucketItemAccessor;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

final class BucketItemPlacementRenderer
implements BlockPlacementRenderer {
    BucketItemPlacementRenderer() {
    }

    @Override
    public boolean renderForHand(Level level, Player player, InteractionHand hand, BlockHitResult hitResult, Camera camera, PoseStack pose, MultiBufferSource.BufferSource buffers) {
        FeatureElement element;
        Fluid fluid;
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (!(item instanceof BucketItem)) {
            return false;
        }
        BucketItem item2 = (BucketItem)item;
        Fluid fluid2 = item2.content;
        if (!(fluid2 instanceof FlowingFluid)) {
            return false;
        }
        FlowingFluid fluid3 = (FlowingFluid)fluid2;
        if (!item2.content.is(ApexTags.Fluids.RENDER_PLACEMENT_WHITELIST)) {
            return false;
        }
        BlockHitResult fluidResult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (fluidResult.getType() != HitResult.Type.BLOCK) {
            return false;
        }
        BucketItemAccessor accessor = (BucketItemAccessor)item2;
        FeatureFlagSet enabledFeatures = level.enabledFeatures();
        AtomicBoolean canBePlaced = new AtomicBoolean(stack.isItemEnabled(enabledFeatures) && (!((fluid = item2.content) instanceof FeatureElement) || (element = (FeatureElement)fluid).isEnabled(level.enabledFeatures())));
        AtomicReference<BlockPos> pos = new AtomicReference<BlockPos>(fluidResult.getBlockPos());
        Optional containedFluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        if (!accessor.ApexCore$canBlockContainFluid(player, level, pos.get(), level.getBlockState(pos.get()))) {
            pos.set(pos.get().relative(fluidResult.getDirection()));
        }
        if (containedFluidStack.isPresent() && fluid3.getFluidType().isVaporizedOnPlacement(level, pos.get(), (FluidStack)containedFluidStack.get())) {
            canBePlaced.set(false);
        } else if (level.dimensionType().ultraWarm() && fluid3.is(FluidTags.WATER)) {
            canBePlaced.set(false);
        } else {
            canBePlaced.set(accessor.ApexCore$canBlockContainFluid(player, level, pos.get(), level.getBlockState(pos.get())));
        }
        FluidState fluidState = item2.content.defaultFluidState();
        BlockState blockState = fluidState.createLegacyBlock();
        BlockPlacementRenderer.renderAt(camera, pose, () -> BlockPlacementRenderer.renderFluidState((BlockAndTintGetter)level, (BlockPos)pos.get(), blockState, fluidState, buffers, pose, canBePlaced.get()));
        return true;
    }
}

