/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import dev.apexstudios.apexcore.lib.tooltip.RegisterTooltipEvent;
import dev.apexstudios.apexcore.lib.tooltip.TooltipMutator;
import dev.apexstudios.apexcore.lib.tooltip.TooltipOrder;
import dev.apexstudios.apexcore.lib.tooltip.TooltipPosition;
import java.util.List;
import java.util.Map;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

public final class TooltipMutationHandler {
    private static final TooltipMutator NOTHING = (stack, context, adder, player, flag) -> {};
    private static final Table<TooltipPosition, TooltipOrder, TooltipMutator> MUTATORS = HashBasedTable.create();

    public static TooltipMutator mutate(TooltipPosition position, TooltipOrder order) {
        TooltipMutator mutator = (TooltipMutator)MUTATORS.get((Object)position, (Object)order);
        return mutator == null ? NOTHING : mutator;
    }

    public static void register(IEventBus modBus) {
        modBus.addListener(FMLCommonSetupEvent.class, event -> event.enqueueWork(() -> {
            Table<TooltipPosition, TooltipOrder, List<TooltipMutator>> table = RegisterTooltipEvent.post();
            for (TooltipPosition position : table.rowKeySet()) {
                Map row = table.row((Object)position);
                for (TooltipOrder order : row.keySet()) {
                    List list = (List)row.get((Object)order);
                    if (list == null || list.isEmpty()) continue;
                    TooltipMutator merged = list.stream().reduce(NOTHING, TooltipMutationHandler::merge);
                    MUTATORS.put((Object)position, (Object)order, (Object)merged);
                }
            }
        }));
    }

    private static TooltipMutator merge(TooltipMutator before, TooltipMutator after) {
        return (stack, context, adder, player, flag) -> {
            before.accept(stack, context, adder, player, flag);
            after.accept(stack, context, adder, player, flag);
        };
    }
}

