/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.block;

import com.mojang.serialization.MapCodec;
import dev.apexstudios.apexcore.lib.block.entity.BaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEntityBlock
extends net.minecraft.world.level.block.BaseEntityBlock {
    protected BaseEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult openMenu(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        MenuProvider menuProvider = blockState.getMenuProvider(level, pos);
        if (menuProvider != null) {
            player.openMenu(menuProvider);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack stack) {
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity base = (BaseBlockEntity)blockEntity;
            base.playerDestroy(level, player, blockState, stack);
        }
        super.playerDestroy(level, player, pos, blockState, blockEntity, stack);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            blockEntity2.setPlacedBy(level, blockState, placer, stack);
        }
        super.setPlacedBy(level, pos, blockState, placer, stack);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockState result = blockState;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            result = blockEntity2.playerWillDestroy(level, result, player);
        }
        return super.playerWillDestroy(level, pos, result, player);
    }

    protected BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = blockState;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            result = blockEntity2.updateShape(result, level, tickAccess, facing, neighborPos, neighborBlockState, random);
        }
        return super.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            blockEntity2.neighborChanged(blockState, level, neighborBlock, orientation, movedByPiston);
        }
        super.neighborChanged(blockState, level, pos, neighborBlock, orientation, movedByPiston);
    }

    protected void onPlace(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            blockEntity2.onPlace(blockState, level, oldBlockState, movedByPiston);
        }
        super.onPlace(blockState, level, pos, oldBlockState, movedByPiston);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BaseBlockEntity blockEntity;
        InteractionResult interactionResult;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof BaseBlockEntity && (interactionResult = (blockEntity = (BaseBlockEntity)blockEntity2).useItemOn(stack, blockState, level, player, hand, result)).consumesAction()) {
            return interactionResult;
        }
        return super.useItemOn(stack, blockState, level, pos, player, hand, result);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        BaseBlockEntity blockEntity;
        InteractionResult interactionResult;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof BaseBlockEntity && (interactionResult = (blockEntity = (BaseBlockEntity)blockEntity2).useWithoutItem(blockState, level, player, result)).consumesAction()) {
            return interactionResult;
        }
        InteractionResult interactionResult2 = this.openMenu(blockState, level, pos, player, result);
        if (interactionResult2.consumesAction()) {
            return interactionResult2;
        }
        return super.useWithoutItem(blockState, level, pos, player, result);
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            n = blockEntity2.getAnalogOutputSignal(blockState, level);
        } else {
            n = 0;
        }
        int blockEntitySignal = n;
        return blockEntitySignal + super.getAnalogOutputSignal(blockState, level, pos);
    }

    public void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier applier) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            blockEntity2.entityInside(blockState, level, entity, applier);
        }
        super.entityInside(blockState, level, pos, entity, applier);
    }

    public void handlePrecipitation(BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            blockEntity2.handlePrecipitation(blockState, level, precipitation);
        }
        super.handlePrecipitation(blockState, level, pos, precipitation);
    }

    public void stepOn(Level level, BlockPos pos, BlockState blockState, Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            blockEntity2.stepOn(level, blockState, entity);
        }
        super.stepOn(level, pos, blockState, entity);
    }

    public void updateEntityMovementAfterFallOn(BlockGetter level, Entity entity) {
        BaseBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(entity.getOnPos());
        if (blockEntity2 instanceof BaseBlockEntity && (blockEntity = (BaseBlockEntity)blockEntity2).updateEntityMovementAfterFallOn(level, entity)) {
            return;
        }
        super.updateEntityMovementAfterFallOn(level, entity);
    }

    @MustBeInvokedByOverriders
    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState, boolean includeData) {
        ItemStack stack = super.getCloneItemStack(level, pos, blockState, includeData);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            blockEntity2.modifyCloneItemStack(stack, level, includeData);
        }
        return stack;
    }

    @MustBeInvokedByOverriders
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState, boolean includeData, Player player) {
        ItemStack stack = super.getCloneItemStack(level, pos, blockState, includeData, player);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity blockEntity2 = (BaseBlockEntity)blockEntity;
            blockEntity2.modifyCloneItemStack(stack, level, includeData, player);
        }
        return stack;
    }
}

