/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.block;

import com.google.errorprone.annotations.ForOverride;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public interface BlockEvents {
    @ForOverride
    default public void playerDestroy(Level level, Player player, BlockPos pos, BlockState blockState, ItemStack stack) {
    }

    @ForOverride
    default public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
    }

    @ForOverride
    default public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState blockState, Player player) {
        return blockState;
    }

    @ForOverride
    default public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        return blockState;
    }

    @ForOverride
    default public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
    }

    @ForOverride
    default public void onPlace(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean movedByPiston) {
    }

    @ForOverride
    default public InteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return InteractionResult.PASS;
    }

    @ForOverride
    default public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        return InteractionResult.PASS;
    }

    @ForOverride
    default public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return 0;
    }

    @ForOverride
    default public void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier applier) {
    }

    @ForOverride
    default public void handlePrecipitation(BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
    }

    @ForOverride
    default public void stepOn(Level level, BlockPos pos, BlockState blockState, Entity entity) {
    }

    @ForOverride
    default public boolean updateEntityMovementAfterFallOn(BlockGetter level, Entity entity) {
        return false;
    }

    @ForOverride
    default public void modifyCloneItemStack(ItemStack stack, LevelReader level, BlockPos pos, BlockState blockState, boolean includeData) {
    }

    @ForOverride
    default public void modifyCloneItemStack(ItemStack stack, LevelReader level, BlockPos pos, BlockState blockState, boolean includeData, Player player) {
        this.modifyCloneItemStack(stack, level, pos, blockState, includeData);
    }
}

