/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component;

import com.google.errorprone.annotations.ForOverride;
import dev.apexstudios.apexcore.lib.component.Component;
import dev.apexstudios.apexcore.lib.component.ComponentHelper;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public abstract class BaseComponentHolder<TBase extends Component<TBase, TObj>, TObj>
implements ComponentHolder<TBase, TObj> {
    private final Map<ComponentType<TBase, ?, TObj, ?>, TBase> components = ComponentHelper.registerComponents(this, BaseComponentHolder::registerComponents);

    @ForOverride
    protected void registerComponents(ComponentRegistrar<TBase, TObj> registrar) {
    }

    @Override
    @Nullable
    public final <TComponent extends TBase> TComponent getComponent(ComponentType<TBase, TComponent, TObj, ?> componentType) {
        return (TComponent)((Component)this.components.get(componentType));
    }

    @Override
    public final <TComponent extends TBase> Optional<TComponent> findComponent(ComponentType<TBase, TComponent, TObj, ?> componentType) {
        return ComponentHolder.super.findComponent(componentType);
    }

    @Override
    public final <TComponent extends TBase> TComponent getComponentOrThrow(ComponentType<TBase, TComponent, TObj, ?> componentType) {
        return ComponentHolder.super.getComponentOrThrow(componentType);
    }

    @Override
    public final <TComponent extends TBase> void runForComponent(ComponentType<TBase, TComponent, TObj, ?> componentType, Consumer<TComponent> action) {
        ComponentHolder.super.runForComponent(componentType, action);
    }

    @Override
    public final boolean hasComponent(ComponentType<TBase, ?, TObj, ?> componentType) {
        return ComponentHolder.super.hasComponent(componentType);
    }

    @Override
    public final Set<ComponentType<TBase, ?, TObj, ?>> getComponentTypes() {
        return this.components.keySet();
    }

    @Override
    public final Collection<TBase> getComponents() {
        return this.components.values();
    }
}

