/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component;

import dev.apexstudios.apexcore.lib.component.Component;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface ComponentHolder<TBase extends Component<TBase, TObj>, TObj> {
    @ApiStatus.NonExtendable
    @Nullable
    public <TComponent extends TBase> TComponent getComponent(ComponentType<TBase, TComponent, TObj, ?> var1);

    @ApiStatus.NonExtendable
    default public <TComponent extends TBase> Optional<TComponent> findComponent(ComponentType<TBase, TComponent, TObj, ?> componentType) {
        return Optional.ofNullable(this.getComponent(componentType));
    }

    @ApiStatus.NonExtendable
    default public <TComponent extends TBase> TComponent getComponentOrThrow(ComponentType<TBase, TComponent, TObj, ?> componentType) {
        return (TComponent)((Component)Objects.requireNonNull(this.getComponent(componentType)));
    }

    @ApiStatus.NonExtendable
    default public <TComponent extends TBase> void runForComponent(ComponentType<TBase, TComponent, TObj, ?> componentType, Consumer<TComponent> action) {
        TComponent component = this.getComponent(componentType);
        if (component != null) {
            action.accept(component);
        }
    }

    @ApiStatus.NonExtendable
    default public boolean hasComponent(ComponentType<TBase, ?, TObj, ?> componentType) {
        return this.getComponent(componentType) != null;
    }

    @ApiStatus.NonExtendable
    public Set<ComponentType<TBase, ?, TObj, ?>> getComponentTypes();

    @ApiStatus.NonExtendable
    public Collection<TBase> getComponents();

    @ApiStatus.NonExtendable
    public TObj unwrap();
}

