/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component;

import dev.apexstudios.apexcore.core.component.ComponentTypeImpl;
import dev.apexstudios.apexcore.lib.component.Component;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponent;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface ComponentType<TBase extends Component<TBase, TObj>, TComponent extends TBase, TObj, TBuilder extends ComponentBuilder> {
    public ResourceLocation registryName();

    @ApiStatus.Internal
    public TComponent newInstance(ComponentHolder<TBase, TObj> var1, Consumer<TBuilder> var2);

    public static <TBase extends Component<TBase, TObj>, TComponent extends TBase, TObj, TBuilder extends ComponentBuilder> ComponentType<TBase, TComponent, TObj, TBuilder> register(Class<TBase> baseType, ResourceLocation registryName, Supplier<TBuilder> builderFactory, BiFunction<ComponentHolder<TBase, TObj>, TBuilder, TComponent> componentFactory) {
        return ComponentTypeImpl.register(baseType, registryName, builderFactory, componentFactory);
    }

    public static <TComponent extends BlockComponent, TBuilder extends ComponentBuilder> ComponentType<BlockComponent, TComponent, Block, TBuilder> registerBlock(ResourceLocation registryName, Supplier<TBuilder> builderFactory, BiFunction<ComponentHolder<BlockComponent, Block>, TBuilder, TComponent> componentFactory) {
        return ComponentType.register(BlockComponent.class, registryName, builderFactory, componentFactory);
    }

    public static <TComponent extends BlockComponent> ComponentType<BlockComponent, TComponent, Block, ComponentBuilder> registerBlock(ResourceLocation registryName, Function<ComponentHolder<BlockComponent, Block>, TComponent> componentFactory) {
        return ComponentType.registerBlock(registryName, ComponentBuilder.NOOP, (holder, builder) -> (BlockComponent)componentFactory.apply((ComponentHolder<BlockComponent, Block>)holder));
    }

    public static <TComponent extends BlockEntityComponent, TBuilder extends ComponentBuilder> ComponentType<BlockEntityComponent, TComponent, BlockEntity, TBuilder> registerBlockEntity(ResourceLocation registryName, Supplier<TBuilder> builderFactory, BiFunction<ComponentHolder<BlockEntityComponent, BlockEntity>, TBuilder, TComponent> componentFactory) {
        return ComponentType.register(BlockEntityComponent.class, registryName, builderFactory, componentFactory);
    }

    public static <TComponent extends BlockEntityComponent> ComponentType<BlockEntityComponent, TComponent, BlockEntity, ComponentBuilder> registerBlockEntity(ResourceLocation registryName, Function<ComponentHolder<BlockEntityComponent, BlockEntity>, TComponent> componentFactory) {
        return ComponentType.registerBlockEntity(registryName, ComponentBuilder.NOOP, (holder, builder) -> (BlockEntityComponent)componentFactory.apply((ComponentHolder<BlockEntityComponent, BlockEntity>)holder));
    }
}

