/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block;

import com.google.errorprone.annotations.ForOverride;
import dev.apexstudios.apexcore.lib.block.BaseEntityBlock;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentHelper;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.types.FluidLoggedBlockComponent;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEntityBlockComponentHolder
extends BaseEntityBlock
implements ComponentHolder<BlockComponent, Block>,
BucketPickup,
LiquidBlockContainer {
    private final Map<ComponentType<BlockComponent, ?, Block, ?>, BlockComponent> components = BlockComponentHelper.registerComponents(this, BaseEntityBlockComponentHolder::registerComponents, new Property[0]);

    protected BaseEntityBlockComponentHolder(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean openMenu(Level level, BlockPos pos, BlockState blockState, Player player) {
        MenuProvider menuProvider = blockState.getMenuProvider(level, pos);
        if (menuProvider == null) {
            return false;
        }
        player.openMenu(menuProvider);
        return true;
    }

    @ForOverride
    protected void registerComponents(ComponentRegistrar<BlockComponent, Block> registrar) {
    }

    @Override
    @Nullable
    public final <TComponent extends BlockComponent> TComponent getComponent(ComponentType<BlockComponent, TComponent, Block, ?> componentType) {
        return (TComponent)this.components.get(componentType);
    }

    @Override
    public final <TComponent extends BlockComponent> Optional<TComponent> findComponent(ComponentType<BlockComponent, TComponent, Block, ?> componentType) {
        return ComponentHolder.super.findComponent(componentType);
    }

    @Override
    public final <TComponent extends BlockComponent> TComponent getComponentOrThrow(ComponentType<BlockComponent, TComponent, Block, ?> componentType) {
        return (TComponent)((BlockComponent)ComponentHolder.super.getComponentOrThrow(componentType));
    }

    @Override
    public final <TComponent extends BlockComponent> void runForComponent(ComponentType<BlockComponent, TComponent, Block, ?> componentType, Consumer<TComponent> action) {
        ComponentHolder.super.runForComponent(componentType, action);
    }

    @Override
    public final boolean hasComponent(ComponentType<BlockComponent, ?, Block, ?> componentType) {
        return ComponentHolder.super.hasComponent(componentType);
    }

    @Override
    public final Set<ComponentType<BlockComponent, ?, Block, ?>> getComponentTypes() {
        return this.components.keySet();
    }

    @Override
    public final Collection<BlockComponent> getComponents() {
        return this.components.values();
    }

    @Override
    public final Block unwrap() {
        return this;
    }

    @MustBeInvokedByOverriders
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return BlockComponentHelper.getStateForPlacement(this, context, this.defaultBlockState());
    }

    @Override
    @MustBeInvokedByOverriders
    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack stack) {
        BlockComponentHelper.playerDestroy(this, level, player, pos, blockState, stack);
        super.playerDestroy(level, player, pos, blockState, blockEntity, stack);
    }

    @Override
    @MustBeInvokedByOverriders
    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        BlockComponentHelper.setPlacedBy(this, level, pos, blockState, placer, stack);
        super.setPlacedBy(level, pos, blockState, placer, stack);
    }

    @Override
    @MustBeInvokedByOverriders
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockState result = BlockComponentHelper.playerWillDestroy(this, level, pos, blockState, player);
        return super.playerWillDestroy(level, pos, result, player);
    }

    @Override
    @MustBeInvokedByOverriders
    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = BlockComponentHelper.updateShape(this, blockState, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
        return super.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }

    @Override
    @MustBeInvokedByOverriders
    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        BlockComponentHelper.neighborChanged(this, blockState, level, pos, neighborBlock, orientation, movedByPiston);
        super.neighborChanged(blockState, level, pos, neighborBlock, orientation, movedByPiston);
    }

    @Override
    @MustBeInvokedByOverriders
    public void onPlace(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean movedByPiston) {
        BlockComponentHelper.onPlace(this, blockState, level, pos, oldBlockState, movedByPiston);
        super.onPlace(blockState, level, pos, oldBlockState, movedByPiston);
    }

    @MustBeInvokedByOverriders
    public void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        BlockComponentHelper.affectNeighborsAfterRemoval(this, blockState, level, pos, movedByPiston);
        super.affectNeighborsAfterRemoval(blockState, level, pos, movedByPiston);
    }

    @Override
    @MustBeInvokedByOverriders
    public InteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        InteractionResult interactionResult = BlockComponentHelper.useItemOn(this, stack, blockState, level, pos, player, hand, result);
        if (interactionResult.consumesAction()) {
            return interactionResult;
        }
        return super.useItemOn(stack, blockState, level, pos, player, hand, result);
    }

    @Override
    @MustBeInvokedByOverriders
    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        InteractionResult interactionResult = BlockComponentHelper.useWithoutItem(this, blockState, level, pos, player, result);
        if (interactionResult.consumesAction()) {
            return interactionResult;
        }
        if (this.openMenu(level, pos, blockState, player)) {
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(blockState, level, pos, player, result);
    }

    @Override
    @MustBeInvokedByOverriders
    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        int componentSignal = BlockComponentHelper.getAnalogOutputSignal(this, blockState, level, pos);
        return componentSignal + super.getAnalogOutputSignal(blockState, level, pos);
    }

    @MustBeInvokedByOverriders
    protected boolean hasAnalogOutputSignal(BlockState blockState) {
        boolean hasSignal = BlockComponentHelper.hasAnalogOutputSignal(this, blockState);
        return hasSignal || super.hasAnalogOutputSignal(blockState);
    }

    @MustBeInvokedByOverriders
    protected boolean isPathfindable(BlockState blockState, PathComputationType pathType) {
        boolean isPathfindable = BlockComponentHelper.isPathfindable(this, blockState, pathType);
        return super.hasAnalogOutputSignal(blockState) && isPathfindable;
    }

    @MustBeInvokedByOverriders
    protected void tick(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockComponentHelper.tick(this, blockState, level, pos, random);
        super.tick(blockState, level, pos, random);
    }

    @Override
    @MustBeInvokedByOverriders
    public void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier applier) {
        BlockComponentHelper.entityInside(this, blockState, level, pos, entity, applier);
        super.entityInside(blockState, level, pos, entity, applier);
    }

    @Override
    @MustBeInvokedByOverriders
    public void handlePrecipitation(BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        BlockComponentHelper.handlePrecipitation(this, blockState, level, pos, precipitation);
        super.handlePrecipitation(blockState, level, pos, precipitation);
    }

    @Override
    @MustBeInvokedByOverriders
    public void stepOn(Level level, BlockPos pos, BlockState blockState, Entity entity) {
        BlockComponentHelper.stepOn(this, level, pos, blockState, entity);
        super.stepOn(level, pos, blockState, entity);
    }

    @MustBeInvokedByOverriders
    protected BlockState rotate(BlockState blockState, Rotation rotation) {
        BlockState result = BlockComponentHelper.rotate(this, blockState, rotation);
        return super.rotate(result, rotation);
    }

    @MustBeInvokedByOverriders
    protected BlockState mirror(BlockState blockState, Mirror mirror) {
        BlockState result = BlockComponentHelper.mirror(this, blockState, mirror);
        return super.mirror(result, mirror);
    }

    @MustBeInvokedByOverriders
    protected FluidState getFluidState(BlockState blockState) {
        FluidState defaultFluidState = super.getFluidState(blockState);
        return BlockComponentHelper.getFluidState(this, blockState, defaultFluidState);
    }

    @MustBeInvokedByOverriders
    public ItemStack pickupBlock(@Nullable LivingEntity player, LevelAccessor level, BlockPos pos, BlockState blockState) {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component == null ? ItemStack.EMPTY : component.pickupBlock(player, level, pos, blockState);
    }

    @MustBeInvokedByOverriders
    public Optional<SoundEvent> getPickupSound() {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component == null ? Optional.empty() : component.getPickupSound();
    }

    @MustBeInvokedByOverriders
    public Optional<SoundEvent> getPickupSound(BlockState blockState) {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component == null ? Optional.empty() : component.getPickupSound(blockState);
    }

    @MustBeInvokedByOverriders
    public boolean canPlaceLiquid(@Nullable LivingEntity player, BlockGetter level, BlockPos pos, BlockState blockState, Fluid fluid) {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component != null && component.canPlaceLiquid(player, level, pos, blockState, fluid);
    }

    @MustBeInvokedByOverriders
    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState blockState, FluidState fluidState) {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component != null && component.placeLiquid(level, pos, blockState, fluidState);
    }

    @MustBeInvokedByOverriders
    protected void onExplosionHit(BlockState blockState, ServerLevel level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        BlockComponentHelper.onExplosionHit(this, blockState, level, pos, explosion, dropConsumer);
        super.onExplosionHit(blockState, level, pos, explosion, dropConsumer);
    }

    @Override
    @MustBeInvokedByOverriders
    public void updateEntityMovementAfterFallOn(BlockGetter level, Entity entity) {
        if (!BlockComponentHelper.updateEntityMovementAfterFallOn(this, level, entity)) {
            super.updateEntityMovementAfterFallOn(level, entity);
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState, boolean includeData) {
        ItemStack stack = super.getCloneItemStack(level, pos, blockState, includeData);
        BlockComponentHelper.modifyCloneItemStack(this, stack, level, pos, blockState, includeData);
        return stack;
    }

    @Override
    @MustBeInvokedByOverriders
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState, boolean includeData, Player player) {
        ItemStack stack = super.getCloneItemStack(level, pos, blockState, includeData);
        BlockComponentHelper.modifyCloneItemStack(this, stack, level, pos, blockState, includeData, player);
        return stack;
    }
}

