/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.entity.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.entity.BaseBlockEntityComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public final class InventoryBlockEntityComponent
extends BaseBlockEntityComponent {
    public static final ComponentType<BlockEntityComponent, InventoryBlockEntityComponent, BlockEntity, Builder> COMPONENT_TYPE = ComponentType.registerBlockEntity(ApexCore.identifier("inventory"), Builder::new, InventoryBlockEntityComponent::new);
    public static final String NBT_INVENTORY = "Inventory";
    private static final ICapabilityProvider<? extends ComponentHolder<BlockEntityComponent, BlockEntity>, @Nullable Direction, IItemHandler> CAPABILITY_PROVIDER = (holder, context) -> {
        InventoryBlockEntityComponent component = holder.getComponent(COMPONENT_TYPE);
        return component == null ? EmptyItemHandler.INSTANCE : component.getItemHandler();
    };
    private final boolean saveToItem;
    private final Inventory inventory;

    private InventoryBlockEntityComponent(ComponentHolder<BlockEntityComponent, BlockEntity> holder, Builder builder) {
        super(holder);
        this.saveToItem = builder.saveToItem;
        this.inventory = new Inventory(builder);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getItems() {
        return NonNullList.copyOf(this.inventory.getItems());
    }

    @Override
    public void saveNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(NBT_INVENTORY, (Tag)this.inventory.serializeNBT(registries));
    }

    @Override
    public void loadNbt(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains(NBT_INVENTORY)) {
            this.inventory.deserializeNBT(registries, tag.getCompoundOrEmpty(NBT_INVENTORY));
        }
    }

    @Override
    public void applyImplicitComponents(DataComponentGetter getter) {
        ItemContainerContents contents = (ItemContainerContents)getter.get(DataComponents.CONTAINER);
        if (!this.saveToItem || contents == null) {
            return;
        }
        for (int i = 0; i < contents.getSlots() && i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, contents.getStackInSlot(i));
        }
    }

    @Override
    public void collectImplicitComponents(DataComponentMap.Builder builder) {
        if (!this.saveToItem) {
            return;
        }
        List<ItemStack> items = IntStream.range(0, this.inventory.getSlots()).mapToObj(arg_0 -> ((Inventory)this.inventory).getStackInSlot(arg_0)).map(ItemStack::copy).toList();
        builder.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(items));
    }

    @Override
    public void removeComponentsFromTag(CompoundTag tag) {
        if (this.saveToItem) {
            tag.remove(NBT_INVENTORY);
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState blockState) {
        Level level = ((BlockEntity)this.unwrap()).getLevel();
        if (level == null) {
            return;
        }
        Block block = blockState.getBlock();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            Containers.dropItemStack((Level)level, (double)x, (double)y, (double)z, (ItemStack)this.inventory.getStackInSlot(i));
        }
        level.updateNeighbourForOutputSignal(pos, block);
    }

    @Override
    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inventory);
    }

    public static <TBlockEntity extends BlockEntity> void registerCapability(BlockEntityType<TBlockEntity> blockEntityType, RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType, InventoryBlockEntityComponent.capability());
    }

    public static <TBlockEntity extends BlockEntity> ICapabilityProvider<TBlockEntity, @Nullable Direction, IItemHandler> capability() {
        return CAPABILITY_PROVIDER;
    }

    public static final class Builder
    implements ComponentBuilder {
        private int limit = 99;
        private final Int2ObjectMap<Consumer<SlotBuilder>> slots = new Int2ObjectOpenHashMap();
        private boolean saveToItem = false;

        public Builder limit(int limit) {
            this.limit = Math.max((int)limit, (int)1);
            return this;
        }

        public Builder slot(int index, Consumer<SlotBuilder> builder) {
            this.slots.merge(index, builder, Consumer::andThen);
            return this;
        }

        public Builder slot(int index) {
            return this.slot(index, Consumers.nop());
        }

        public Builder slots(int index, int ... indices) {
            for (int slot : indices) {
                this.slot(slot);
            }
            return this.slot(index);
        }

        public Builder slots(int row, int col) {
            return this.slots(row * col);
        }

        public Builder slots(int count, ObjIntConsumer<SlotBuilder> consumer) {
            IntStream.range(0, count).forEach(index -> this.slot(index, builder -> consumer.accept((SlotBuilder)builder, index)));
            return this;
        }

        public Builder slots(int count, Consumer<SlotBuilder> consumer) {
            return this.slots(count, (SlotBuilder builder, int index) -> consumer.accept((SlotBuilder)builder));
        }

        public Builder slots(int count) {
            return this.slots(count, Consumers.nop());
        }

        public Builder saveToItem() {
            this.saveToItem = true;
            return this;
        }
    }

    private static final class Inventory
    extends ItemStackHandler {
        private final int limit;
        private final Int2ObjectMap<SlotBuilder.Limit> slotLimit = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<SlotBuilder.Validator> slotValidator = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<SlotBuilder.Listener> slotListener = new Int2ObjectOpenHashMap();

        private Inventory(Builder builder) {
            super(builder.slots.size());
            this.limit = Math.max((int)builder.limit, (int)99);
            builder.slots.forEach((index, consumer) -> {
                SlotBuilder slotBuilder = new SlotBuilder();
                consumer.accept(slotBuilder);
                this.slotLimit.put(index, (Object)slotBuilder.limit);
                this.slotValidator.put(index, (Object)slotBuilder.validator);
                this.slotListener.put(index, (Object)slotBuilder.listener);
            });
        }

        public NonNullList<ItemStack> getItems() {
            return this.stacks;
        }

        public int getSlotLimit(int slot) {
            return this.limit;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            SlotBuilder.Limit limit = (SlotBuilder.Limit)this.slotLimit.get(slot);
            int baseLimit = super.getStackLimit(slot, stack);
            return limit == null ? baseLimit : Math.min((int)baseLimit, (int)limit.limit(slot, (IItemHandler)this, stack));
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            SlotBuilder.Validator test = (SlotBuilder.Validator)this.slotValidator.get(slot);
            return test == null || test.isValid(slot, (IItemHandler)this, stack);
        }

        protected void onContentsChanged(int slot) {
            SlotBuilder.Listener listener = (SlotBuilder.Listener)this.slotListener.get(slot);
            if (listener != null) {
                listener.invoke(slot, (IItemHandlerModifiable)this);
            }
        }
    }

    public static final class SlotBuilder {
        private Limit limit = (index, inventory, stack) -> stack.getMaxStackSize();
        private Validator validator = (index, inventory, stack) -> true;
        private Listener listener = (index, inventory) -> {};

        public SlotBuilder limit(int limit) {
            return this.limit((index, inventory, stack) -> limit);
        }

        public SlotBuilder limit(Limit limit) {
            this.limit = limit;
            return this;
        }

        public SlotBuilder validator(Validator validator, Validator.Merge merge) {
            this.validator = merge.merge(this.validator, validator);
            return this;
        }

        public SlotBuilder validator(Validator validator) {
            return this.validator(validator, Validator.Merge.AND);
        }

        public SlotBuilder listener(Listener listener) {
            this.listener = this.listener.andThen(listener);
            return this;
        }

        @FunctionalInterface
        public static interface Limit {
            public int limit(int var1, IItemHandler var2, ItemStack var3);
        }

        @FunctionalInterface
        public static interface Validator {
            public boolean isValid(int var1, IItemHandler var2, ItemStack var3);

            public static enum Merge {
                AND{

                    @Override
                    public Validator merge(Validator left, Validator right) {
                        return (index, inventory, stack) -> left.isValid(index, inventory, stack) && right.isValid(index, inventory, stack);
                    }
                }
                ,
                OR{

                    @Override
                    public Validator merge(Validator left, Validator right) {
                        return (index, inventory, stack) -> left.isValid(index, inventory, stack) || right.isValid(index, inventory, stack);
                    }
                };


                public abstract Validator merge(Validator var1, Validator var2);
            }
        }

        @FunctionalInterface
        public static interface Listener {
            public void invoke(int var1, IItemHandlerModifiable var2);

            default public Listener andThen(Listener listener) {
                return (index, inventory) -> {
                    this.invoke(index, inventory);
                    listener.invoke(index, inventory);
                };
            }
        }
    }
}

