/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.entity.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.entity.BaseBlockEntityComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponentTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class LockBlockEntityComponent
extends BaseBlockEntityComponent {
    public static final ComponentType<BlockEntityComponent, LockBlockEntityComponent, BlockEntity, ComponentBuilder> COMPONENT_TYPE = ComponentType.registerBlockEntity(ApexCore.identifier("lock"), LockBlockEntityComponent::new);
    private LockCode lockCode = LockCode.NO_LOCK;

    private LockBlockEntityComponent(ComponentHolder<BlockEntityComponent, BlockEntity> holder) {
        super(holder);
    }

    public boolean canAccess(ItemStack stack) {
        return this.lockCode.unlocksWith(stack);
    }

    public void setLockCode(LockCode lockCode) {
        if (!this.lockCode.equals((Object)lockCode)) {
            this.lockCode = lockCode;
            ((BlockEntity)this.unwrap()).setChanged();
        }
    }

    @Override
    public void loadNbt(CompoundTag tag, HolderLookup.Provider registries) {
        this.lockCode = LockCode.fromTag((CompoundTag)tag, (HolderLookup.Provider)registries);
    }

    @Override
    public void saveNbt(CompoundTag tag, HolderLookup.Provider registries) {
        this.lockCode.addToTag(tag, registries);
    }

    @Override
    public void applyImplicitComponents(DataComponentGetter getter) {
        this.lockCode = (LockCode)getter.getOrDefault(DataComponents.LOCK, (Object)LockCode.NO_LOCK);
    }

    @Override
    public void collectImplicitComponents(DataComponentMap.Builder builder) {
        if (!this.lockCode.equals((Object)LockCode.NO_LOCK)) {
            builder.set(DataComponents.LOCK, (Object)this.lockCode);
        }
    }

    @Override
    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("lock");
    }

    public static boolean isLocked(BlockEntity blockEntity, Player player) {
        if (!(blockEntity instanceof ComponentHolder)) {
            return false;
        }
        LockBlockEntityComponent component = ((ComponentHolder)blockEntity).getComponent(BlockEntityComponentTypes.LOCK);
        return component != null && !component.canAccess(player.getMainHandItem());
    }

    public static boolean isLocked(BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return true;
        }
        return LockBlockEntityComponent.isLocked(blockEntity, player);
    }
}

