/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.entity.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.entity.BaseBlockEntityComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.entity.types.InventoryBlockEntityComponent;
import dev.apexstudios.apexcore.lib.util.ApexUtil;
import java.util.Objects;
import java.util.function.LongSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public final class LootTableBlockEntityComponent
extends BaseBlockEntityComponent {
    public static final ComponentType<BlockEntityComponent, LootTableBlockEntityComponent, BlockEntity, ComponentBuilder> COMPONENT_TYPE = ComponentType.registerBlockEntity(ApexCore.identifier("loot_table"), LootTableBlockEntityComponent::new);
    public static final String NBT_LOOT_TABLE = "LootTable";
    public static final String NBT_SEED = "LootTableSeed";
    @Nullable
    private ResourceKey<LootTable> lootTableId = null;
    private long seed = -1L;

    private LootTableBlockEntityComponent(ComponentHolder<BlockEntityComponent, BlockEntity> holder) {
        super(holder);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTableId() {
        return this.lootTableId;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTableId, long seed) {
        this.setLootTable(lootTableId);
        this.setLootTableSeed(seed);
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTableId) {
        if (!Objects.equals(this.lootTableId, lootTableId)) {
            this.lootTableId = lootTableId;
            ((BlockEntity)this.unwrap()).setChanged();
        }
    }

    public void setLootTableSeed(long seed) {
        if (this.seed != seed) {
            this.seed = seed;
            ((BlockEntity)this.unwrap()).setChanged();
        }
    }

    @Override
    public void loadNbt(CompoundTag tag, HolderLookup.Provider registries) {
        this.lootTableId = tag.read(NBT_LOOT_TABLE, LootTable.KEY_CODEC).orElse(null);
        this.seed = tag.getLongOr(NBT_SEED, 0L);
    }

    @Override
    public void saveNbt(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.lootTableId != null) {
            tag.putString(NBT_LOOT_TABLE, this.lootTableId.location().toString());
            if (this.seed != -1L) {
                tag.putLong(NBT_SEED, this.seed);
            }
        }
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState blockState, Player player) {
        if (level.isClientSide || !player.isCreative()) {
            LootTableBlockEntityComponent.unpack((BlockEntity)this.unwrap(), player);
        }
        return super.playerWillDestroy(level, pos, blockState, player);
    }

    public static void unpack(BlockGetter level, BlockPos pos, @Nullable Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            LootTableBlockEntityComponent.unpack(blockEntity, player);
        }
    }

    public static void unpack(BlockEntity blockEntity, @Nullable Player player) {
        if (!blockEntity.hasLevel() || !(blockEntity instanceof ComponentHolder)) {
            return;
        }
        ComponentHolder holder = (ComponentHolder)blockEntity;
        InventoryBlockEntityComponent inventory = holder.getComponent(BlockEntityComponentTypes.INVENTORY);
        LootTableBlockEntityComponent lootTable = holder.getComponent(COMPONENT_TYPE);
        if (inventory == null || lootTable == null) {
            return;
        }
        ResourceKey<LootTable> lootTableId = lootTable.getLootTableId();
        long seed = lootTable.getSeed();
        lootTable.setLootTable(null, -1L);
        ApexUtil.unpackLootTable(blockEntity.getLevel(), blockEntity.getBlockPos(), player, lootTableId, seed, inventory.getItemHandler());
    }

    public static void setLootTable(BlockGetter level, BlockPos pos, @Nullable ResourceKey<LootTable> lootTableId, LongSupplier seed) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            LootTableBlockEntityComponent.setLootTable(blockEntity, lootTableId, seed);
        }
    }

    public static void setLootTable(BlockGetter level, BlockPos pos, @Nullable ResourceKey<LootTable> lootTableId, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            LootTableBlockEntityComponent.setLootTable(blockEntity, lootTableId, random);
        }
    }

    public static void setLootTable(BlockGetter level, BlockPos pos, @Nullable ResourceKey<LootTable> lootTableId, long seed) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            LootTableBlockEntityComponent.setLootTable(blockEntity, lootTableId, seed);
        }
    }

    public static void setLootTable(BlockGetter level, BlockPos pos, @Nullable ResourceKey<LootTable> lootTableId) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            LootTableBlockEntityComponent.setLootTable(blockEntity, lootTableId);
        }
    }

    public static void setLootTable(BlockEntity blockEntity, @Nullable ResourceKey<LootTable> lootTableId, LongSupplier seed) {
        if (blockEntity instanceof ComponentHolder) {
            ((ComponentHolder)blockEntity).runForComponent(COMPONENT_TYPE, component -> component.setLootTable(lootTableId, seed.getAsLong()));
        }
    }

    public static void setLootTable(BlockEntity blockEntity, @Nullable ResourceKey<LootTable> lootTableId, RandomSource random) {
        LootTableBlockEntityComponent.setLootTable(blockEntity, lootTableId, () -> ((RandomSource)random).nextLong());
    }

    public static void setLootTable(BlockEntity blockEntity, @Nullable ResourceKey<LootTable> lootTableId, long seed) {
        LootTableBlockEntityComponent.setLootTable(blockEntity, lootTableId, () -> seed);
    }

    public static void setLootTable(BlockEntity blockEntity, @Nullable ResourceKey<LootTable> lootTableId) {
        if (blockEntity instanceof ComponentHolder) {
            ((ComponentHolder)blockEntity).runForComponent(COMPONENT_TYPE, component -> component.setLootTable(lootTableId));
        }
    }

    public static void setLootTableSeed(BlockEntity blockEntity, LongSupplier seed) {
        if (blockEntity instanceof ComponentHolder) {
            ((ComponentHolder)blockEntity).runForComponent(COMPONENT_TYPE, component -> component.setLootTableSeed(seed.getAsLong()));
        }
    }

    public static void setLootTableSeed(BlockEntity blockEntity, RandomSource random) {
        LootTableBlockEntityComponent.setLootTableSeed(blockEntity, () -> ((RandomSource)random).nextLong());
    }

    public static void setLootTableSeed(BlockEntity blockEntity, long seed) {
        LootTableBlockEntityComponent.setLootTableSeed(blockEntity, () -> seed);
    }
}

