/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.entity.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.entity.BaseBlockEntityComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public final class NameableBlockEntityComponent
extends BaseBlockEntityComponent
implements Nameable {
    public static final String NBT_CUSTOM_NAME = "CustomName";
    public static final ComponentType<BlockEntityComponent, NameableBlockEntityComponent, BlockEntity, Builder> COMPONENT_TYPE = ComponentType.registerBlockEntity(ApexCore.identifier("nameable"), Builder::new, NameableBlockEntityComponent::new);
    @Nullable
    private final Component defaultName;
    @Nullable
    private Component customName = null;

    private NameableBlockEntityComponent(ComponentHolder<BlockEntityComponent, BlockEntity> holder, Builder builder) {
        super(holder);
        this.defaultName = builder.defaultName;
    }

    public void setCustomName(@Nullable Component customName) {
        this.customName = customName;
        ((BlockEntity)this.unwrap()).setChanged();
    }

    public Component getName() {
        return this.defaultName == null ? ((BlockEntity)this.unwrap()).getBlockState().getBlock().getName() : this.defaultName;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public Component getDisplayName() {
        return this.customName == null ? this.getName() : this.customName;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    @Override
    public void applyImplicitComponents(DataComponentGetter getter) {
        this.customName = (Component)getter.get(DataComponents.CUSTOM_NAME);
    }

    @Override
    public void collectImplicitComponents(DataComponentMap.Builder builder) {
        if (this.defaultName != null) {
            builder.set(DataComponents.ITEM_NAME, (Object)this.defaultName);
        }
        if (this.customName != null) {
            builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
        }
    }

    @Override
    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove(NBT_CUSTOM_NAME);
    }

    @Override
    public void loadNbt(CompoundTag tag, HolderLookup.Provider registries) {
        this.customName = BlockEntity.parseCustomNameSafe((Tag)tag.get(NBT_CUSTOM_NAME), (HolderLookup.Provider)registries);
    }

    @Override
    public void saveNbt(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.customName != null) {
            tag.store(NBT_CUSTOM_NAME, ComponentSerialization.CODEC, (Object)this.customName);
        }
    }

    public static final class Builder
    implements ComponentBuilder {
        @Nullable
        private Component defaultName = null;

        public Builder defaultName(Component defaultName) {
            this.defaultName = defaultName;
            return this;
        }
    }
}

