/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BaseBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentHelper;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.util.ApexUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public final class DyeableBlockComponent
extends BaseBlockComponent {
    public static final ComponentType<BlockComponent, DyeableBlockComponent, Block, Builder> COMPONENT_TYPE = ComponentType.registerBlock(ApexCore.identifier("dyeable"), Builder::new, DyeableBlockComponent::new);
    private final EnumProperty<DyeColor> property;
    private final DyeColor defaultColor;

    private DyeableBlockComponent(ComponentHolder<BlockComponent, Block> holder, Builder builder) {
        super(holder);
        builder.allow(builder.defaultColor);
        this.property = EnumProperty.create((String)"color", DyeColor.class, (Enum[])((DyeColor[])builder.colors.toArray(DyeColor[]::new)));
        this.defaultColor = builder.defaultColor;
    }

    public Property<DyeColor> property() {
        return this.property;
    }

    public DyeColor defaultColor() {
        return this.defaultColor;
    }

    public DyeColor get(BlockState blockState) {
        return (DyeColor)blockState.getValue(this.property);
    }

    public BlockState set(BlockState blockState, DyeColor color) {
        return (BlockState)blockState.setValue(this.property, (Comparable)color);
    }

    @Override
    public BlockState registerDefaultBlockState(BlockState blockState) {
        return this.set(blockState, this.defaultColor);
    }

    @Override
    public void createBlockStateDefinition(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)this.property);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context, BlockState blockState) {
        return DyeableBlockComponent.getStateForPlacement(this.property, this.defaultColor, context, blockState);
    }

    @Override
    public InteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return DyeableBlockComponent.useItemOn(this.property, stack, blockState, level, pos);
    }

    @Override
    public void modifyCloneItemStack(ItemStack stack, LevelReader level, BlockPos pos, BlockState blockState, boolean includeData) {
        DyeableBlockComponent.modifyCloneItemStack(this.property, stack, blockState, includeData, null);
    }

    @Override
    public void modifyCloneItemStack(ItemStack stack, LevelReader level, BlockPos pos, BlockState blockState, boolean includeData, Player player) {
        DyeableBlockComponent.modifyCloneItemStack(this.property, stack, blockState, includeData, player);
    }

    public static boolean isAllowed(Property<DyeColor> property, @Nullable DyeColor color) {
        return color != null && property.getPossibleValues().contains(color);
    }

    @Nullable
    public static DyeColor getColorForPlacement(Property<DyeColor> property, BlockPlaceContext context) {
        DyeColor color;
        Player player = context.getPlayer();
        if (player != null) {
            InteractionHand otherHand = switch (context.getHand()) {
                default -> throw new MatchException(null, null);
                case InteractionHand.OFF_HAND -> InteractionHand.MAIN_HAND;
                case InteractionHand.MAIN_HAND -> InteractionHand.OFF_HAND;
            };
            DyeColor dyeColor = DyeColor.getColor((ItemStack)player.getItemInHand(otherHand));
            if (DyeableBlockComponent.isAllowed(property, dyeColor)) {
                return dyeColor;
            }
        }
        return DyeableBlockComponent.isAllowed(property, color = (DyeColor)context.getItemInHand().get(DataComponents.BASE_COLOR)) ? color : null;
    }

    public static DyeColor getColorForPlacement(Property<DyeColor> property, DyeColor defaultColor, BlockPlaceContext context) {
        DyeColor result = DyeableBlockComponent.getColorForPlacement(property, context);
        return result == null ? defaultColor : result;
    }

    public static BlockState getStateForPlacement(Property<DyeColor> property, DyeColor defaultColor, BlockPlaceContext context, BlockState blockState) {
        DyeColor color = DyeableBlockComponent.getColorForPlacement(property, defaultColor, context);
        return (BlockState)blockState.setValue(property, (Comparable)color);
    }

    public static InteractionResult useItemOn(Property<DyeColor> property, ItemStack stack, BlockState blockState, Level level, BlockPos pos) {
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        DyeColor currentColor = (DyeColor)blockState.getValue(property);
        if (color != null && color != currentColor && DyeableBlockComponent.isAllowed(property, color)) {
            if (!level.isClientSide) {
                DyeableBlockComponent.set(property, blockState, color, level, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void modifyCloneItemStack(Property<DyeColor> property, ItemStack stack, BlockState blockState, boolean includeData, @Nullable Player player) {
        blockState.getOptionalValue(property).ifPresent(color -> {
            if (includeData || player != null && player.isCreative()) {
                stack.set(DataComponents.BASE_COLOR, color);
            }
        });
    }

    public static void set(Property<DyeColor> property, BlockState blockState, DyeColor color, Level level, BlockPos pos) {
        BlockState newBlockState = (BlockState)blockState.setValue(property, (Comparable)color);
        level.setBlock(pos, newBlockState, 3);
        BlockComponentHelper.runForComponent(blockState, BlockComponentTypes.MULTI_BLOCK, component -> {
            BlockPos origin = component.getOrigin(pos, newBlockState);
            int index = component.indexOf(newBlockState);
            for (int i = 0; i < component.size(); ++i) {
                if (i == index) continue;
                BlockState newSubBlockState = component.withIndex(newBlockState, i);
                BlockPos subPos = component.getPos(origin, newSubBlockState);
                level.setBlock(subPos, newSubBlockState, 3);
            }
        });
    }

    public static final class Builder
    implements ComponentBuilder {
        private DyeColor defaultColor = DyeColor.WHITE;
        private final Set<DyeColor> colors = EnumSet.allOf(DyeColor.class);

        public Builder defaultColor(DyeColor defaultColor) {
            this.defaultColor = defaultColor;
            return this;
        }

        public Builder allow(DyeColor color) {
            this.colors.add(color);
            return this;
        }

        public Builder allow(DyeColor ... colors) {
            Collections.addAll(this.colors, colors);
            return this;
        }

        public Builder disallow(DyeColor color) {
            this.colors.remove(color);
            return this;
        }

        public Builder disallow(DyeColor ... colors) {
            ApexUtil.removeAll(this.colors, colors);
            return this;
        }
    }
}

